<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Pricing Table Style
 *
 * @package big-event
 * @author CodexCoder
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_pricing_table_6 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'			=> '',
			'overlay'			=> '',
			'color_variation'	=> '',
			'title'				=> '',
			'sub_title'			=> '',
			'categories'		=> '',
			'post_count'		=> '',
			'order'				=> '',
			'orderby'			=> '',
			'be_class'			=> ''
		), $atts ) );
		ob_start();
			big_event_pricing_table_6( $bg_image, $title, $sub_title, $categories, $post_count, $order, $orderby, $be_class );
		return ob_get_clean();
	}
}


vc_map( array(
	'name'			=> esc_html__( 'Price Table 06', 'big-event' ),
	'base'			=> 'big_event_pricing_table_6',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Section Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
        array(
            'param_name'    => 'categories',
            'type'          => 'dropdown',
            'value'         => big_event_get_terms_vc('pricing_category'),
            'heading'       => esc_html__('Category filter:', 'big-event'),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Limit', 'big-event' ),
			'param_name'	=> 'post_count',
			'description'	=> esc_html__( 'How many tables you wanna display?', 'big-event' ),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order By', 'big-event' ),
			'param_name'	=> 'orderby',
			'description'	=> esc_html__( 'Select how to retrieve price table', 'big-event' ),
			'value'			=> array(
				esc_html__( 'Select order by', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )				=> 'date',
				esc_html__( 'Name', 'big-event' )				=> 'name',
				esc_html__( 'Modified', 'big-event' )			=> 'modified',
				esc_html__( 'Author', 'big-event' )				=> 'author',
				esc_html__( 'Random', 'big-event' )				=> 'rand',
				esc_html__( 'Comment Count', 'big-event' )		=> 'comment_count'
			),
			'group'			=> esc_html__( 'Price Table', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Classes', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_pricing_table_6( $bg_image, $title, $sub_title, $categories, $post_count, $order, $orderby, $be_class ) {
	$bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
	?>
<!-- Pricing start here -->
<section class="pricing pricing-two pricing-eight<?php echo ( empty( $bg_image ) ) ? ' padding-120' : ''; echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-image: url( <?php echo esc_attr( $bg_image[0] ); ?> );">

  <?php
  if( ! empty( $bg_image ) ) : ?>
  <div class="overlay">
  <?php
  endif; ?>
    <div class="container">

      <?php
      if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

      <div class="section-header text-center">

        <?php
        if( ! empty( $title ) ) :

          echo '<h3>' . esc_html( $title ) . '</h3>';

        endif; ?>

        <?php
        if( ! empty( $sub_title ) ) :

          echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

        endif; ?>
        
      </div>

      <?php endif; ?>

      <div class="pricing-items">
        <div class="row">
		<?php
		if( $categories == NULL ) :
			$pricing_table = new WP_Query( array(
				'post_type'			=> 'price-table',
				'posts_per_page'	=> $post_count,
				'order'				=> $order,
				'orderby'			=> $orderby
			) );
        else :
            $pricing_table = new WP_Query( array(
				'post_type'			=> 'price-table',
				'posts_per_page'	=> $post_count,
				'order'				=> $order,
				'orderby'			=> $orderby,
              	'tax_query' => array(
                array(
                  'taxonomy' => 'pricing_category',
                  'field'    => 'term_id',
                  'terms'    => $categories,
                ),
              ),
            ) );
        endif;

		if( $pricing_table->have_posts() ) :

			$i = 1;

			while( $pricing_table->have_posts() ) : $pricing_table->the_post();

			if( $i == 1 ) :
				$color = ' first';
			elseif( $i == 2 ) :
				$color = ' second';
			elseif( $i == 3 ) :
				$color = ' third';
			else :
				$color = ' fourth';
			endif;

			if( function_exists( 'cs_get_option' ) ) :

				$price_table_options 			= get_post_meta( get_the_ID(), '_be_pricing_table_options', true );
				$be_price_table_currency		= isset( $price_table_options['be_price_table_currency'] ) ? $price_table_options['be_price_table_currency'] : '';
				$be_price_table_rate			= isset( $price_table_options['be_price_table_rate'] ) ? $price_table_options['be_price_table_rate'] : '';
				$be_price_table_offers			= isset( $price_table_options['be_price_table_offers'] ) ? $price_table_options['be_price_table_offers'] : '';
				$be_price_table_button_text		= isset( $price_table_options['be_price_table_button_text'] ) ? $price_table_options['be_price_table_button_text'] : '';
				$be_price_table_button_url		= isset( $price_table_options['be_price_table_button_url'] ) ? $price_table_options['be_price_table_button_url'] : '';

			endif; ?>
            <div class="col-md-4 col-sm-6 col-xs-12">
                <div class="pricing-item ">
                    <div class="pricing-item-inner">
                        <div class="pricing-header">
                            <?php 
                            the_title( '<h3 class="name">', '</h3>' );

                            if( ! empty( $be_price_table_currency ) && ! empty( $be_price_table_rate ) ) :

                                echo '<h2 class="amount"><sup>' . esc_html( $be_price_table_currency ) . '</sup>' . esc_html( $be_price_table_rate ) . '</h2>';

                            endif; 
                            ?>                        
                        </div>
                        <!-- pricing-header -->
                        <div class="pricing-options">
                            <?php foreach( $be_price_table_offers as $be_price_table_offer ) : ?>

                                <p><?php echo esc_html( $be_price_table_offer['offer_title'] ); ?><span class="<?php echo ( $be_price_table_offer['offer_icon'] == 'fa fa-times' ) ? ' ' . 'off' : '' ?>"><i class="<?php echo esc_attr( $be_price_table_offer['offer_icon'] ); ?>" aria-hidden="true"></i></span></p>

                            <?php endforeach; ?>                        
                        </div>
                        <!-- pricing-options -->
                    </div>
					<?php if( ! empty( $be_price_table_button_text ) && ! empty( $be_price_table_button_url ) ) : ?>

						<div class="pricing-button">
							<a href="<?php echo esc_url( $be_price_table_button_url ); ?>">
								<?php echo esc_html( $be_price_table_button_text ); ?>
							</a>
						</div>

					<?php endif; ?>                    
                </div>
            </div>
			<?php 
            $i++; endwhile;
			wp_reset_postdata();
			endif; 
            ?>
        </div><!-- row -->
      </div><!-- pricing items -->
      
    </div><!-- container -->
  <?php
  if( ! empty( $bg_image ) ) : ?>
  </div>
  <?php
  endif; ?>
</section><!-- pricing -->
<!-- Pricing end here -->
<?php }