<?php
/**
 * Big Event Sponsors Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_hotel_list( $title,$subtitle,$hotels,$be_class ){ ?>
    <!-- testimonial start here -->
    <section class="venue-section padding-120">
        <div class="container">
            <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                <div class="section-header text-center">
                  <?php
                  if( ! empty( $title ) ) :
                    echo '<h3>' . esc_html( $title ) . '</h3>';
                  endif;

                  if( ! empty( $subtitle ) ) :
                    echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                  endif; ?>
                </div>
            <?php endif; ?> 

            <div class="section-wrapper">
                <?php if (!empty($hotels)): ?>
                <div class="venue-list">
                    <div class="row">
                        <?php 
                        foreach($hotels as $hotel): 
                            $hotelImage = wp_get_attachment_image_src( $hotel['image'], 'full' );
                        ?>
                        <div class="col-md-4 col-sm-6">
                            <div class="venue-item">
                                <?php if( ! empty( $hotelImage[0] ) ) : ?>
                                <div class="venue-thumb">
                                    <img src="<?php echo esc_url($hotelImage[0]) ?>" alt="<?php esc_attr($hotel['title'])?>">
                                </div>
                                <?php endif; ?>                                
                                <div class="venue-content">
                                    <?php
                                    if( ! empty( $hotel['heading'] ) ) :
                                      echo '<h4>' . esc_html( $hotel['heading'] ) . '</h4>';
                                    endif;

                                    if( ! empty( $hotel['description'] ) ) :
                                        echo '<p>'.nl2br($hotel['description']).'</p>';
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div> 
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php }