<?php
/**
 * Big Event Travel With Map Info Shorcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_hotel_list extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'			=> '',
			'subtitle'		=> '',
			'hotels'	=> '',			
			'be_class'		=> ''
		), $atts ) );
		$hotels 	= ( array ) vc_param_group_parse_atts( $hotels );
		ob_start();
			big_event_hotel_list( $title,$subtitle,$hotels,$be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Hotels List', 'big-event' ),
	'base'			=> 'big_event_hotel_list',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title'
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Hotels', 'big-event' ),
			'param_name'	=> 'hotels',
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Title', 'big-event' ),
					'param_name'	=> 'heading'
				),
				array(
					'type'			=> 'textarea',
					'heading'		=> esc_html__( 'Description', 'big-event' ),
					'param_name'	=> 'description'
				),				
			)
		),		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;