<?php
/**
 * Big Event Google Map
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

/**
 * Big Event Google Map With Contact Form Shortcode
 *
 * Visual Composer of Google Map
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.3.2
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_google_map_7 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'      => '',
			'bg_color'      => '',
			'title'         => '',
			'sub_title'		=> '',
			'form_bg_color'	=> '',
			'contact_form'	=> '',
			'map_icon'		=> '',
			'latitute'		=> '',
			'longitute'		=> '',
			'map_zoom'		=> '',
			'map_color'		=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
			big_event_google_map_7($bg_image,$bg_color,$title,$sub_title,$form_bg_color,$contact_form,$map_icon,$latitute,$longitute,$map_zoom,$map_color,$be_class);
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Google Map 7 (Contact Form)', 'big-event' ),
	'base'		=> 'big_event_google_map_7',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
        array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Section Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'std'           => '#001A29',
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Form Background Color', 'big-event' ),
			'param_name'	=> 'form_bg_color',
			'std'           => '#001A29',
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Contact Form Shortcode', 'big-event' ),
			'param_name'	=> 'contact_form',
			'group'			=> esc_html__( 'Contact Form', 'big-event' )
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Map Icon', 'big-event' ),
			'param_name'	=> 'map_icon',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Latitude', 'big-event' ),
			'param_name'	=> 'latitute',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Longitute', 'big-event' ),
			'param_name'	=> 'longitute',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Map Zoom', 'big-event' ),
			'param_name'	=> 'map_zoom',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Map Color', 'big-event' ),
			'param_name'	=> 'map_color',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_google_map_7($bg_image,$bg_color,$title,$sub_title,$form_bg_color,$contact_form,$map_icon,$latitute,$longitute,$map_zoom,$map_color,$be_class) {
	$map_icon = wp_get_attachment_url( $map_icon );
    $bg_image = wp_get_attachment_image_src( $bg_image, 'full' );
	?>
<!-- Map start here -->
    <section class="get-touch<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="<?php echo (!empty($bg_image)) ? 'background-image:url('.esc_url( $bg_image[0] ).')':'background-color:'.$bg_color.'' ?>">
        <div class="overlay">
            <div class="container">
                <div class="row">
                    <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>
                    <div class="section-header text-center">
                      <?php
                      if( ! empty( $title ) ) :
                        echo '<h3>' . esc_html( $title ) . '</h3>';
                      endif;

                      if( ! empty( $sub_title ) ) :
                        echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';
                      endif; 
                      ?>        
                    </div>
                    <?php endif; ?>
                    <!-- Map start here -->
                    <div class="map-wrapper">
                        <div id="map6" class="home-map<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>">
                          <div id="home-map6" class="map" data-map-icon="<?php echo esc_url( $map_icon ); ?>" data-map-latitute="<?php echo esc_attr( $latitute ) ?>" data-map-longitude="<?php echo esc_attr( $longitute ) ?>" data-map-zoom="<?php echo esc_attr( $map_zoom ) ?>" data-map-color="<?php echo esc_attr( $map_color ) ?>"></div>
                        </div>                        
                        <!-- Map end here -->

                        <div class="register-form clearfix" style="<?php echo (!empty($form_bg_color)) ? 'background-image:background-color:'.$form_bg_color.'':'' ?>">
                            <div class="register-form-inner">                                
                                <?php echo do_shortcode($contact_form) ?>
                            </div>

                        </div>
                    </div>
                </div>


            </div>
        </div>
    </section>
<!-- Map end here -->
	<?php
}