<?php
/**
 * Big Event Google Map Shortcode
 *
 * Visual Composer of Google Map
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_google_map_5 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'map_icon'		=> '',
			'latitute'		=> '',
			'longitute'		=> '',
			'map_zoom'		=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
			big_event_google_map_5( $map_icon, $latitute, $longitute, $map_zoom, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Google Map 5 (Dark 2)', 'big-event' ),
	'base'		=> 'big_event_google_map_5',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Map Icon', 'big-event' ),
			'param_name'	=> 'map_icon',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Latitude', 'big-event' ),
			'param_name'	=> 'latitute',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Longitute', 'big-event' ),
			'param_name'	=> 'longitute',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Map Zoom', 'big-event' ),
			'param_name'	=> 'map_zoom',
			'group'			=> esc_html__( 'Google Map', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;