<?php
/**
 * Big Event Expectation Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_expectation( $layout, $bg_color, $title, $sub_title, $expectations, $be_class ) { ?>
<!-- services start here -->
<section class="services padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" <?php echo $bg_color ? 'style="background-color: '.esc_attr( $bg_color ).'"':''?>>
  <div class="container <?php echo esc_attr($layout)?> ">
  
    <?php
    if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

    <div class="section-header text-center">

    	<?php
    	if( ! empty( $title ) ) :

    		echo '<h3>' . esc_html( $title ) . '</h3>';

    	endif; ?>

    	<?php
    	if( ! empty( $sub_title ) ) :

    		echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

    	endif; ?>
        
    </div>

    <?php endif; ?>

	<?php
	if( ! empty( $expectations ) ) : ?>
    <div class="row">

		<?php foreach( $expectations as $expectation ) :
		$image = wp_get_attachment_url( $expectation['image'] );
		?>

	      <div class="col-md-4 col-sm-6 col-xs-12">
	        <div class="service-item">
	          <img src="<?php echo esc_url( $image ); ?>" alt="service image" class="img-responsive">
	          <h4><?php echo esc_attr( $expectation['title'] ); ?></h4>
	          <p><?php echo esc_attr( $expectation['description'] ); ?></p>
	        </div><!-- service-item -->
	      </div>

		<?php endforeach; ?>

    </div><!-- row -->
    <?php
    endif; ?>
  </div><!-- container -->
</section><!-- services -->
<!-- services end here -->
<?php }