<?php
/**
 * Big Event Shortcodes
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_expectation extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'layout'			=> 'white',
			'bg_color'			=> '',
			'title'				=> '',
			'sub_title'			=> '',
			'expectations'		=> '',
			'be_class'			=> ''
		), $atts ) );
		$expectations 	= ( array ) vc_param_group_parse_atts( $expectations );
		ob_start();
			big_event_expectation( $layout, $bg_color, $title, $sub_title, $expectations, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Expectation', 'big-event' ),
	'base'			=> 'big_event_expectation',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
        array(
            "type"          => "dropdown",
            "heading"       => esc_html__( "Layout", 'big-event' ),
            "param_name"    => "layout",                
            "value"		=> array(
                esc_html__( "Select layout",'big-event')	=> "",
                esc_html__( "White",'big-event')	=> "white",
                esc_html__( "Dark", 'big-event' )	=> "dark",
            ),
            "std"    => "white",
            'group'			=> esc_html__( 'Expectation', 'big-event' )
        ),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'Expectation', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Expectation', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Expectation', 'big-event' ),
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Expectation', 'big-event' ),
			'param_name'	=> 'expectations',
			'group'			=> esc_html__( 'Expectation', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Heading', 'big-event' ),
					'param_name'	=> 'title'
				),
				array(
					'type'			=> 'textarea',
					'heading'		=> esc_html__( 'Description', 'big-event' ),
					'param_name'	=> 'description'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;