<?php
/**
 * Events
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.0.0
 * @version 1.0.0
 */

if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_events_grid extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'			=> '',
			'subtitle'		=> '',
			'post_limit'	=> 4,
			'tag'           => '',
			'category'      => '',
			'order'			=> '',
			'orderby'		=> '',
			'excerpt_limit'	=> '',
			'detail_txt'	=> 'View Detail',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
        big_event_events_grid( $title, $subtitle, $post_limit, $tag, $category, $order, $orderby, $detail_txt, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Events', 'big-event' ),
	'base'			=> 'big_event_events_grid',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'General', 'big-event' )
		),        
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Post Limit', 'big-event' ),
			'param_name'	=> 'post_limit',
            'std'           => 4,
			'description'	=> esc_html__( 'How many posts want to display?', 'big-event' ),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
        array(
            "type" => "textfield",
            "heading"       => esc_html__("Filter by tag slug:", "big-event"),
            "param_name"    => "tag",
            "description"   => esc_html__("To filter by tag, enter tag slugs here separated by comma (ex: tag1,tag2,tag3). Leave the field empty if you want to display the recent campaigns", "big-event"),
            'group'			=> esc_html__( 'Post Query', 'big-event' )
        ),
        array(
            "type" => "textfield",
            "heading"       => esc_html__("Filter by category slug:", "big-event"),
            "param_name"    => "category",
            "description"   => esc_html__("To filter by category, enter category slugs here separated by comma (ex: cat1,cat2,cat3). Leave the field empty if you want to display the recent events", 'big-event' ),
            'group'			=> esc_html__( 'Post Query', 'big-event' )
        ),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'orderby',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )			=> 'date',
				esc_html__( 'Name', 'big-event' )			=> 'name',
				esc_html__( 'Modified', 'big-event' )		=> 'modified',
				esc_html__( 'Author', 'big-event' )			=> 'author',
				esc_html__( 'Random', 'big-event' )			=> 'random',
				esc_html__( 'Comment Count', 'big-event' )	=> 'comment_count',
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Detail Button Text', 'big-event' ),
			'param_name'	=> 'detail_txt',
            'std'           => 'View Detail',
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' ),
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;
function big_event_events_grid( $title, $subtitle, $post_limit, $tag, $category, $order, $orderby, $detail_txt, $be_class ) {
    $css_classes = array(
        'feature-show-section',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
    $tags = explode(',', $tag);
    $categories = explode(',', $category);
    ?>
	<!-- start campaign-program section -->
	<div class="<?php echo implode( ' ', $css_classes ) ?>">
        <div class="container">
            <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                <div class="section-header text-center">

                    <?php
                    if( ! empty( $title ) ) :
                        echo '<h3>' . esc_html( $title ) . '</h3>';
                    endif;

                    if( ! empty( $subtitle ) ) :
                        echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                    endif; ?>

                </div>
            <?php 
            endif;
            
            if(!empty($tag)):
                $events = new WP_Query( array(
                    'post_type'				=> 'event',
                    'posts_per_page'		=> $post_limit,
                    'ignore_sticky_post'	=> true,
                    'post_status'           => 'publish',
                    'order'                 => $order,
                    'orderby'               => $orderby,
                    'tax_query' => array(
                        array (
                            'taxonomy' => 'event_tags',
                            'field' => 'slug',
                            'terms' => $tags,
                        )
                    ),
                ) );                
            elseif(!empty($category)):
                $events = new WP_Query( array(
                    'post_type'				=> 'event',
                    'posts_per_page'		=> $post_limit,
                    'ignore_sticky_post'	=> true,
                    'post_status'           => 'publish',
                    'order'                 => $order,
                    'orderby'               => $orderby,
                    'tax_query' => array(
                        array (
                            'taxonomy' => 'event_categories',
                            'field' => 'slug',
                            'terms' => $categories,
                        )
                    ),
                ) );                
            else:
                $events = new WP_Query( array(
                    'post_type'				=> 'event',
                    'post_status'           => 'publish',
                    'posts_per_page'		=> $post_limit,
                    'order'                 => $order,
                    'orderby'               => $orderby,
                    'ignore_sticky_post'	=> true
                ) );                
            endif;

            if( $events->have_posts() ) :
                while( $events->have_posts() ) : $events->the_post();
                $eoptions = get_post_meta( get_the_ID(), '_be_event_options', true );
                $event_date         = isset( $eoptions['event_date'] ) ? $eoptions['event_date'] : '';
                $event_month  	= isset( $eoptions['event_month'] ) ? $eoptions['event_month'] : '';
                $event_info         = isset( $eoptions['event_info'] ) ? $eoptions['event_info'] : '';
                ?>
                <div class="col-md-6">
                    <div class="fs-item">
                        <?php if( has_post_thumbnail() ) : ?>
                        <div class="fs-thumb">
                            <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'big-event-260-300' ); ?></a>
                            <div class="fs-date"><span><?php echo esc_html($event_date) ?></span><span><?php echo esc_html($event_month) ?></span></div>
                        </div>
                        <?php endif; ?>
                        <div class="fs-content">
                            <?php 
                            the_title('<h5><a href="'.get_the_permalink().'">', '</a></h5>');
                            
                            if(!empty($event_info)) :
                            ?>
                            <ul class="fs-info">
                                <?php 
                                foreach ($event_info as $info) :
                                    echo '<li><span>'.esc_html($info['title']).':</span>'.esc_html($info['description']).'</li>';
                                endforeach;
                                ?>
                            </ul>
                            <?php endif; ?>
                            <a href="<?php the_permalink() ?>" class="custom-btn"><?php echo esc_html($detail_txt) ?></a>
                        </div>
                    </div>
                </div>                
                <?php 
                endwhile; wp_reset_postdata();
            endif; 
            ?>                                                                                
        </div><!-- /.container -->
	</div>
	<!-- end campaign-program section -->
<?php }