<?php
/**
 * Events
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.0.0
 * @version 1.0.0
 */

if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_events_tab extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bgcolor'		=> '',
			'title'			=> '',
			'subtitle'		=> '',						
			'be_class'		=> ''
		), $atts ) );
		ob_start();
        big_event_events_tab( $bgcolor, $title, $subtitle, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Events Tab', 'big-event' ),
	'base'			=> 'big_event_events_tab',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html( 'Background Color', 'big-event' ),
			'param_name'	=> 'bgcolor',
			'std'           => '#F5F4F9',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'General', 'big-event' )
		),	
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' ),
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;
function big_event_events_tab( $bgcolor, $title, $subtitle, $be_class ) {
    $css_classes = array(
        'upcoming-event',
        'event-tab',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
    
    $section_attribute = array();
    $section_attribute[] = 'class="' . implode( ' ', $css_classes ) . '"';
    if(!empty($bgcolor)):
        $section_attribute[] = 'style="background-color: '.esc_attr($bgcolor).'"';
    endif;
    ?>
	<!-- start campaign-program section -->
	<div <?php echo implode( ' ', $section_attribute ) ?>>
        <div class="container">
            <div class="row">
                <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                <div class="section-header text-center">
                    <?php
                    if( ! empty( $title ) ) :
                        echo '<h3>' . esc_html( $title ) . '</h3>';
                    endif;

                    if( ! empty( $subtitle ) ) :
                        echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                    endif; ?>

                </div>
                <?php endif; ?>
                <div class="section-wrapper">
                    <div class="events-type">
                        <?php 
                        $terms = get_terms( array(
                            'taxonomy' => 'event_categories',
                            'hide_empty' => false,
                        ) );
                        ?>
                        <ul class="events-type-list">
                            <?php 
                            $l = 0;                             
                            foreach ($terms as $term): $l++;
                                if($l == 1) {
                                    $liclass = 'active';
                                } else {
                                    $liclass = '';
                                }
                                echo '<li class="'.$liclass.'"><a href="#'.$term->slug.'" title="" data-toggle="tab">'.$term->name.'</a></li>';
                            endforeach;
                            ?>                            
                        </ul>
                    </div>
                    <div class="tab-content">
                        <?php
                        $l = 0;
                        foreach ($terms as $term): $l++;
                            if($l == 1) {
                                $tabclass = 'active in';
                            } else {
                                $tabclass = '';
                            }
                            $term_data = get_term_meta( $term->term_id, '_event_categories_options', true );
                            $ctitle = isset( $term_data['ctitle'] ) ? $term_data['ctitle'] : '';
                            $csubtitle = isset( $term_data['ctitle'] ) ? $term_data['csubtitle'] : '';
                            $csdesc = isset( $term_data['ctitle'] ) ? $term_data['csdesc'] : '';
                            $cicon = isset( $term_data['ctitle'] ) ? $term_data['cicon'] : '';                            
                            $cicon_attr = wp_get_attachment_image_src($cicon, 'full');
                            $cicon_alt = get_post_meta($cicon, '_wp_attachment_image_alt', true);                            
                            
                            $btntext = isset( $term_data['btntext'] ) ? $term_data['btntext'] : '';
                            $btncolor = isset( $term_data['btncolor'] ) ? $term_data['btncolor'] : '';
                            $btnurl = isset( $term_data['btnurl'] ) ? $term_data['btnurl'] : '';
                            $category_link = get_category_link( $term->term_id );
                            $button_attribute = array();
                            $button_attribute[] = 'class="' . implode( ' ', $css_classes ) . '"';
                            if(!empty($btncolor)):
                                $button_attribute[] = 'style="background-color: '.esc_attr($btncolor).'"';
                            endif;
                            if(!empty($btnurl)):
                                $button_attribute[] = 'href="'.esc_url($btnurl).'"';
                            else:
                                $button_attribute[] = 'href="'.esc_url($category_link).'"';
                            endif;
                        ?>
                        <div id="<?php echo $term->slug; ?>" class="tab-pane fade <?php echo $tabclass; ?>"> 
                            <div class="upcoming-event-title">
                                <div class="event-item">
                                    <div class="event-item-inner event-item-padding">
                                        <?php if (!empty($cicon)): ?>
                                        <div class="event-icon">
                                            <img src="<?php echo esc_url($cicon_attr[0]) ?>" alt="<?php echo esc_attr($cicon_alt) ?>">
                                        </div>
                                        <?php
                                        endif;
                                        if (!empty($ctitle)):
                                            echo '<h4>'.esc_html($ctitle).'</h4>';
                                        endif;
                                        
                                        if (!empty($csubtitle)):
                                            echo '<p>'.esc_html($csubtitle).'</p>';
                                        endif;
                                        
                                        if (!empty($csdesc)):
                                            echo '<p>'.esc_html($csdesc).'</p>';
                                        endif;
                                        
                                        if (!empty($btntext)):
                                            echo '<a '.implode( ' ', $button_attribute ).'>'.esc_html($btntext).'</a>';
                                        endif;
                                        ?>                                        
                                        
                                    </div><!--event-item-inner end-->
                                </div><!--event-item end-->
                            </div><!--upcoming-event-title end-->
                            <div class="upcoming-event-desc">
                                <?php
                                $events = new WP_Query( array(
                                    'post_type'				=> 'event',
                                    'posts_per_page'		=> 1,
                                    'ignore_sticky_post'	=> true,
                                    'post_status'           => 'publish',
                                    'tax_query' => array(
                                        array (
                                            'taxonomy' => 'event_categories',
                                            'field' => 'slug',
                                            'terms' => $term->slug,
                                        )
                                    ),
                                ) ); 
                                if( $events->have_posts()) :
                                    while ($events->have_posts()) : $events->the_post();
                                    $eoptions = get_post_meta( get_the_ID(), '_be_event_options', true );
                                    
                                    $coundown_time = isset( $eoptions['be_coundown_time'] ) ? $eoptions['be_coundown_time'] : '';
                                    $time_offset = isset( $eoptions['time_offset'] ) ? $eoptions['time_offset'] : '0';
                                    $event_date = isset( $eoptions['event_date'] ) ? $eoptions['event_date'] : '';
                                    $event_month = isset( $eoptions['event_month'] ) ? $eoptions['event_month'] : '';
                                    $time = isset( $eoptions['time'] ) ? $eoptions['time'] : '';
                                    $location = isset( $eoptions['location'] ) ? $eoptions['location'] : '';
                                    $event_short_desc   = isset( $eoptions['event_short_desc'] ) ? $eoptions['event_short_desc'] : '';
                                    $organizers_name = isset( $eoptions['event_organizers_name'] ) ? $eoptions['event_organizers_name'] : '';
                                    $organizer_designation = isset( $eoptions['organizer_designation'] ) ? $eoptions['organizer_designation'] : '';
                                    $ticket_price   = isset( $eoptions['event_ticket_price'] ) ? $eoptions['event_ticket_price'] : '';
                                    $ticket_btntext   = isset( $eoptions['ticket_btntext'] ) ? $eoptions['ticket_btntext'] : '';
                                    $ticket_url   = isset( $eoptions['ticket_url'] ) ? $eoptions['ticket_url'] : '';
                                    
                                    $organizer_image = isset( $eoptions['event_organizer_image'] ) ? $eoptions['event_organizer_image'] : '';
                                    $organizer_image_attr = wp_get_attachment_image_src($organizer_image, 'big-event-popular-posts-thumb');
                                    $organizer_image_alt = get_post_meta($organizer_image, '_wp_attachment_image_alt', true);
                                ?>
                                <div class="event-item">
                                    <div class="event-item-inner">
                                        <div class="event-thumb">
                                            <a href="<?php the_permalink() ?>"><?php the_post_thumbnail('big-event-370-400') ?></a> 
                                            <div class="event-date">
                                                <div class="event-date-inner">
                                                    <?php 
                                                    if (!empty($event_date)):
                                                        echo '<h4>'.esc_html($event_date).'</h4> ';
                                                    endif;
                                                    
                                                    if (!empty($event_month)):
                                                        echo '<p>'.esc_html($event_month).'</p> ';
                                                    endif;
                                                    ?>
                                                </div>
                                            </div><!--event-date end-->
                                            <div class="upcoming-event-count">                                                
                                                <ul id="upcoming-event-countdown" class="countdown upcoming-event-countdown" data-coundowntime="<?php echo esc_attr($coundown_time) ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($time_offset) ?>" class="countdown clearfix">
                                                    <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                                                        <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
                                                    </li>

                                                    <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                                                        <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
                                                    </li>

                                                    <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                                                        <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
                                                    </li>

                                                    <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                                                        <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
                                                    </li>
                                                </ul>                                                
                                            </div> <!--upcoming-event-count end-->      
                                        </div><!--event-thumb end-->
                                        <div class="event-content event-item-padding">
                                            <?php the_title('<h4><a href="'.get_the_permalink().'">', '</a></h4>'); ?>
                                            <ul class="time-location">
                                                <?php 
                                                if (!empty($time)):
                                                    echo '<li><span>'.esc_html('Time','big-event').' :</span> '.esc_html($time).'</li>';
                                                endif;
                                                if (!empty($location)):
                                                    echo '<li><span>'.esc_html('Location','big-event').' :</span> '.esc_html($location).'</li>';
                                                endif;
                                                ?>
                                            </ul>
                                            <?php 
                                            if (!empty($event_short_desc)):
                                                echo '<p>'.esc_html($event_short_desc).'</p>';
                                            endif;
                                            ?>                                            
                                            <div class="organizer-ticket">
                                                <div class="organizer">
                                                    <?php if (!empty($organizer_image)): ?>
                                                    <div class="orgranizer-img">
                                                        <img src="<?php echo esc_url($organizer_image_attr[0]) ?>" alt="<?php echo esc_attr($organizer_image_alt) ?>">
                                                    </div>
                                                    <?php endif;  ?>
                                                    <div class="organizer-intro">
                                                        <?php  
                                                        if (!empty($organizers_name)):
                                                            echo '<span class="organizer-name">'.esc_html($organizers_name).'</span>';
                                                        endif;
                                                        if (!empty($organizer_designation)):
                                                            echo '<span class="organizer-desig">'.esc_html($organizer_designation).'</span>';
                                                        endif;
                                                        ?>                          
                                                    </div>
                                                </div><!--organizer end-->
                                                <div class="event-price">
                                                    <?php  
                                                    if (!empty($ticket_price)):
                                                        echo '<span class="ticket-price">'.esc_html($ticket_price).'</span>';
                                                    endif;
                                                    if (!empty($ticket_btntext)):
                                                        echo '<span class="ticket"><a href="'.esc_url($ticket_url).'">'.esc_html($ticket_btntext).'</a></span>';
                                                    endif;
                                                    ?>                 
                                                </div><!--event-price end-->
                                            </div><!--organizer-ticket end-->
                                        </div><!--event-content end-->
                                    </div><!--event-item-inner end-->
                                </div><!--event-item end-->
                                <?php endwhile; wp_reset_postdata(); endif;?>
                            </div><!--upcoming-event-desc end-->
                        </div><!--tab-pane end-->
                        <?php endforeach; ?>
                    </div>
                </div>
                                                                                               
            </div><!-- /.container -->
        </div><!-- /.container -->
	</div>
	<!-- end campaign-program section -->
<?php }