<?php
/**
 * Events Countdown
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.0.0
 * @version 1.0.0
 */

if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_events_countdown extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bgimage'		=> '',
			'overlay'		=> '',
			'title'			=> '',
			'subtitle'		=> '',			
			'post_limit'	=> 6,
			'tag'           => '',
			'category'      => '',
			'order'			=> '',
			'orderby'		=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
        big_event_events_countdown( $bgimage, $overlay, $title, $subtitle, $post_limit, $tag, $category, $order, $orderby, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Events Countdown', 'big-event' ),
	'base'			=> 'big_event_events_countdown',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
        array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bgimage',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
        array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html( 'Overlay Color', 'big-event' ),
			'param_name'	=> 'overlay',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'General', 'big-event' )
		),        
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Post Limit', 'big-event' ),
			'param_name'	=> 'post_limit',
            'std'           => 6,
			'description'	=> esc_html__( 'How many posts want to display?', 'big-event' ),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
        array(
            "type" => "textfield",
            "heading"       => esc_html__("Filter by tag slug:", "big-event"),
            "param_name"    => "tag",
            "description"   => esc_html__("To filter by tag, enter tag slugs here separated by comma (ex: tag1,tag2,tag3). Leave the field empty if you want to display the recent campaigns", "big-event"),
            'group'			=> esc_html__( 'Post Query', 'big-event' )
        ),
        array(
            "type" => "textfield",
            "heading"       => esc_html__("Filter by category slug:", "big-event"),
            "param_name"    => "category",
            "description"   => esc_html__("To filter by category, enter category slugs here separated by comma (ex: cat1,cat2,cat3). Leave the field empty if you want to display the recent events", 'big-event' ),
            'group'			=> esc_html__( 'Post Query', 'big-event' )
        ),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'orderby',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )			=> 'date',
				esc_html__( 'Name', 'big-event' )			=> 'name',
				esc_html__( 'Modified', 'big-event' )		=> 'modified',
				esc_html__( 'Author', 'big-event' )			=> 'author',
				esc_html__( 'Random', 'big-event' )			=> 'random',
				esc_html__( 'Comment Count', 'big-event' )	=> 'comment_count',
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' ),
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;
function big_event_events_countdown( $bgimage, $overlay, $title, $subtitle, $post_limit, $tag, $category, $order, $orderby, $be_class ) {
    $bgimageurl = wp_get_attachment_url( $bgimage, 'full' );
    
    $section_attribute[] = 'class="upcoming-show"';
    if(!empty($bgimage)):
        $section_attribute[] = 'style="background-image: url('.esc_attr($bgimageurl).')"';
    endif;
    
    $overlay_classes = array(
        'overlay',
        'padding-120'
    );
    if(!empty($be_class)):
        $overlay_classes[] = $be_class;
    endif;
    $overlay_class = implode( ' ', $overlay_classes );
    $overlay_attribute = array();
    $overlay_attribute[] = 'class="' . esc_attr( $overlay_class ) . '"';
    if(!empty($overlay)):
        $overlay_attribute[] = 'style="background-color: '.esc_attr($overlay).'"';
    endif; 
    $tags = explode(',', $tag);
    $categories = explode(',', $category);
    ?>
	<!-- start campaign-program section -->
	<div <?php echo implode( ' ', $section_attribute ) ?>>
        <div <?php echo implode( ' ', $overlay_attribute ) ?>>
            <div class="container">
                <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                    <div class="section-header text-center">

                        <?php
                        if( ! empty( $title ) ) :

                            echo '<h3>' . esc_html( $title ) . '</h3>';

                        endif;

                        if( ! empty( $subtitle ) ) :

                            echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';

                        endif; ?>

                    </div>
                <?php 
                endif;

                if(!empty($tag)):
                    $events = new WP_Query( array(
                        'post_type'				=> 'event',
                        'posts_per_page'		=> $post_limit,
                        'ignore_sticky_post'	=> true,
                        'post_status'           => 'publish',
                        'order'                 => $order,
                        'orderby'               => $orderby,
                        'tax_query' => array(
                            array (
                                'taxonomy' => 'event_tags',
                                'field' => 'slug',
                                'terms' => $tags,
                            )
                        ),
                    ) );                
                elseif(!empty($category)):
                    $events = new WP_Query( array(
                        'post_type'				=> 'event',
                        'posts_per_page'		=> $post_limit,
                        'ignore_sticky_post'	=> true,
                        'post_status'           => 'publish',
                        'order'                 => $order,
                        'orderby'               => $orderby,
                        'tax_query' => array(
                            array (
                                'taxonomy' => 'event_categories',
                                'field' => 'slug',
                                'terms' => $categories,
                            )
                        ),
                    ) );                
                else:
                    $events = new WP_Query( array(
                        'post_type'				=> 'event',
                        'post_status'           => 'publish',
                        'posts_per_page'		=> $post_limit,
                        'order'                 => $order,
                        'orderby'               => $orderby,
                        'ignore_sticky_post'	=> true
                    ) );                
                endif;

                if( $events->have_posts() ) :
                ?>
                <div class="section-wrapper1">
                    <div class="uc-show-list" data-eventlimit="<?php echo esc_attr($post_limit) ?>">
                    <?php
                    $i = 0;
                    while( $events->have_posts() ) : $events->the_post(); $i++;
                    $eoptions = get_post_meta( get_the_ID(), '_be_event_options', true );
                    $event_date   = isset( $eoptions['event_date'] ) ? $eoptions['event_date'] : '';
                    $event_month  = isset( $eoptions['event_month'] ) ? $eoptions['event_month'] : '';
                    $location  	  = isset( $eoptions['location'] ) ? $eoptions['location'] : '';
                    $coundown_time = isset( $eoptions['be_coundown_time'] ) ? $eoptions['be_coundown_time'] : '';                    
                    $time_offset = isset( $eoptions['time_offset'] ) ? $eoptions['time_offset'] : '0';                    
                    $ticket_status = isset( $eoptions['ticket_status'] ) ? $eoptions['ticket_status'] : '';
                    $ticket_btntext = isset( $eoptions['ticket_btntext'] ) ? $eoptions['ticket_btntext'] : '';
                    $ticket_url = isset( $eoptions['ticket_url'] ) ? $eoptions['ticket_url'] : '';
                    $show_classes = array(
                        'uc-show-item',
                        $ticket_status
                    );
                    if(!empty($event_date)):
                    ?>
                        <div class="<?php echo implode( ' ', $show_classes ) ?>">
                            <div class="uc-show-content">
                                <div class="uc-show-date">
                                    <span><?php echo esc_html($event_date) ?></span>
                                    <span><?php echo esc_html($event_month) ?></span>
                                </div>
                                <div class="uc-show-text">
                                    <?php
                                    the_title('<h6><a href="'.get_the_permalink().'">', '</a></h6>');
                                    ?>
                                    <p><?php echo esc_html($location) ?></p>
                                </div>
                            </div>
                            <div class="uc-show-countdown">
                                <ul id="event-countdown-<?php echo $i; ?>" class="countdown uc-coundown clearfix" data-coundowntime="<?php echo esc_attr($coundown_time) ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($time_offset) ?>" class="countdown clearfix">
                                    <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
                                    </li>

                                    <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
                                    </li>

                                    <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
                                    </li>

                                    <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                                        <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
                                    </li>
                                </ul>
                            </div>
                            <?php if(!empty($ticket_btntext)): ?>
                            <div class="uc-show-button">
                                <a href="<?php echo esc_url($ticket_url); ?>" class="custom-btn"><?php echo esc_html($ticket_btntext); ?></a>
                            </div>
                            <?php endif; ?>
                        </div>                                                    
                    <?php endif; endwhile; wp_reset_postdata(); ?>
                    </div>
                </div>
                <?php endif; ?>                                                                                
            </div><!-- /.container -->
        </div>
	</div>
	<!-- end campaign-program section -->
<?php }