<?php
/**
 * Events
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 2.0.0
 * @version 1.0.0
 */

if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_events_2 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'			=> '',
			'subtitle'		=> '',
			'post_limit'	=> 4,
			'tag'           => '',
			'category'      => '',
			'order'			=> '',
			'orderby'		=> '',
			'pagination'	=> '',
			'be_class'		=> ''
		), $atts ) );
		ob_start();
        big_event_events_2( $title, $subtitle, $post_limit, $tag, $category, $order, $orderby, $pagination, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Events 2', 'big-event' ),
	'base'			=> 'big_event_events_2',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'General', 'big-event' )
		),        
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Post Limit', 'big-event' ),
			'param_name'	=> 'post_limit',
            'std'           => 4,
			'description'	=> esc_html__( 'How many posts want to display?', 'big-event' ),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
        array(
            "type" => "textfield",
            "heading"       => esc_html__("Filter by tag slug:", "big-event"),
            "param_name"    => "tag",
            "description"   => esc_html__("To filter by tag, enter tag slugs here separated by comma (ex: tag1,tag2,tag3). Leave the field empty if you want to display the recent campaigns", "big-event"),
            'group'			=> esc_html__( 'Post Query', 'big-event' )
        ),
        array(
            "type" => "textfield",
            "heading"       => esc_html__("Filter by category slug:", "big-event"),
            "param_name"    => "category",
            "description"   => esc_html__("To filter by category, enter category slugs here separated by comma (ex: cat1,cat2,cat3). Leave the field empty if you want to display the recent events", 'big-event' ),
            'group'			=> esc_html__( 'Post Query', 'big-event' )
        ),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'order',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'DESC', 'big-event' )			=> 'DESC',
				esc_html__( 'ASC', 'big-event' )			=> 'ASC'
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Order', 'big-event' ),
			'param_name'	=> 'orderby',
			'value'			=> array(
				esc_html__( 'Select Order', 'big-event' )	=> '',
				esc_html__( 'Date', 'big-event' )			=> 'date',
				esc_html__( 'Name', 'big-event' )			=> 'name',
				esc_html__( 'Modified', 'big-event' )		=> 'modified',
				esc_html__( 'Author', 'big-event' )			=> 'author',
				esc_html__( 'Random', 'big-event' )			=> 'random',
				esc_html__( 'Comment Count', 'big-event' )	=> 'comment_count',
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
        array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Show Pagination', 'big-event' ),
			'param_name'	=> 'pagination',
			'value'			=> array(
				esc_html__( 'Select Pagination', 'big-event' )	=> '',
				esc_html__( 'Yes', 'big-event' )			=> 'yes',
				esc_html__( 'No', 'big-event' )				=> 'no'
			),
			'group'			=> esc_html__( 'Post Query', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' ),
			'group'			=> esc_html__( 'Extra Class', 'big-event' )
		)
	)
) );
endif;
function big_event_events_2( $title, $subtitle, $post_limit, $tag, $category, $order, $orderby, $pagination, $be_class ) {
    $css_classes = array(
        'featured-event',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
    $tags = explode(',', $tag);
    $categories = explode(',', $category);
    ?>
	<!-- start campaign-program section -->
	<div class="<?php echo implode( ' ', $css_classes ) ?>">
        <div class="container">
            <div class="row">
            <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
                <div class="section-header text-center">

                    <?php
                    if( ! empty( $title ) ) :
                        echo '<h3>' . esc_html( $title ) . '</h3>';
                    endif;

                    if( ! empty( $subtitle ) ) :
                        echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                    endif; ?>

                </div>
            <?php 
            endif;
            if(is_front_page()):
                $paged = (get_query_var('page')) ? get_query_var('page') : 1;
            else:
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            endif;
            if(!empty($tag)):
                $events = new WP_Query( array(
                    'post_type'				=> 'event',
                    'posts_per_page'		=> $post_limit,
                    'ignore_sticky_post'	=> true,
                    'post_status'           => 'publish',
                    'order'                 => $order,
                    'orderby'               => $orderby,
                    'paged'                 => $paged,
                    'tax_query' => array(
                        array (
                            'taxonomy' => 'event_tags',
                            'field' => 'slug',
                            'terms' => $tags,
                        )
                    ),
                ) );                
            elseif(!empty($category)):
                $events = new WP_Query( array(
                    'post_type'				=> 'event',
                    'posts_per_page'		=> $post_limit,
                    'ignore_sticky_post'	=> true,
                    'post_status'           => 'publish',
                    'order'                 => $order,
                    'orderby'               => $orderby,
                    'paged'                 => $paged,
                    'tax_query' => array(
                        array (
                            'taxonomy' => 'event_categories',
                            'field' => 'slug',
                            'terms' => $categories,
                        )
                    ),
                ) );                
            else:
                $events = new WP_Query( array(
                    'post_type'				=> 'event',
                    'post_status'           => 'publish',
                    'posts_per_page'		=> $post_limit,
                    'order'                 => $order,
                    'orderby'               => $orderby,
                    'paged'                 => $paged,
                    'ignore_sticky_post'	=> true
                ) );                
            endif;
            ?>
            <div class="event-wrapper">
                <?php
                if( $events->have_posts() ) :
                    while( $events->have_posts() ) : $events->the_post();
                    $eoptions = get_post_meta( get_the_ID(), '_be_event_options', true );
                    $event_date    = isset( $eoptions['event_date'] ) ? $eoptions['event_date'] : '';
                    $event_month   = isset( $eoptions['event_month'] ) ? $eoptions['event_month'] : '';
                    $time   = isset( $eoptions['time'] ) ? $eoptions['time'] : '';
                    $location   = isset( $eoptions['location'] ) ? $eoptions['location'] : '';
                    $event_short_desc   = isset( $eoptions['event_short_desc'] ) ? $eoptions['event_short_desc'] : '';
                    $organizers_name = isset( $eoptions['event_organizers_name'] ) ? $eoptions['event_organizers_name'] : '';
                    $organizer_designation = isset( $eoptions['organizer_designation'] ) ? $eoptions['organizer_designation'] : '';
                    $ticket_price   = isset( $eoptions['event_ticket_price'] ) ? $eoptions['event_ticket_price'] : '';
                    $ticket_btntext   = isset( $eoptions['ticket_btntext'] ) ? $eoptions['ticket_btntext'] : '';
                    $ticket_url   = isset( $eoptions['ticket_url'] ) ? $eoptions['ticket_url'] : '';

                    $organizer_image = isset( $eoptions['event_organizer_image'] ) ? $eoptions['event_organizer_image'] : '';
                    $organizer_image_attr = wp_get_attachment_image_src($organizer_image, 'big-event-popular-posts-thumb');
                    $organizer_image_alt = get_post_meta($organizer_image, '_wp_attachment_image_alt', true);
                    ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="event-item">
                            <div class="event-item-inner">
                                <div class="event-thumb">
                                    <a href="<?php the_permalink() ?>"><?php the_post_thumbnail('big-event-gallery-three-column') ?></a> 
                                    <div class="event-date">
                                        <div class="event-date-inner">
                                            <?php 
                                            if (!empty($event_date)):
                                                echo '<h4>'.esc_html($event_date).'</h4> ';
                                            endif;

                                            if (!empty($event_month)):
                                                echo '<p>'.esc_html($event_month).'</p> ';
                                            endif;
                                            ?>
                                        </div>
                                    </div><!--event-date end-->                                     
                                </div><!--event-thumb end-->
                                <div class="event-content event-item-padding">
                                    <?php the_title('<h4><a href="'.get_the_permalink().'">', '</a></h4>'); ?>
                                    <ul class="time-location">
                                        <?php 
                                        if (!empty($time)):
                                            echo '<li><span>'.esc_html('Time','big-event').' :</span> '.esc_html($time).'</li>';
                                        endif;
                                        if (!empty($location)):
                                            echo '<li><span>'.esc_html('Location','big-event').' :</span> '.esc_html($location).'</li>';
                                        endif;
                                        ?>
                                    </ul>
                                    <?php 
                                    if (!empty($event_short_desc)):
                                        echo '<p>'.esc_html($event_short_desc).'</p>';
                                    endif;
                                    ?>                                            
                                    <div class="organizer-ticket">
                                        <div class="organizer">
                                            <?php if (!empty($organizer_image)): ?>
                                            <div class="orgranizer-img">
                                                <img src="<?php echo esc_url($organizer_image_attr[0]) ?>" alt="<?php echo esc_attr($organizer_image_alt) ?>">
                                            </div>
                                            <?php endif;  ?>
                                            <div class="organizer-intro">
                                                <?php  
                                                if (!empty($organizers_name)):
                                                    echo '<span class="organizer-name">'.esc_html($organizers_name).'</span>';
                                                endif;
                                                if (!empty($organizer_designation)):
                                                    echo '<span class="organizer-desig">'.esc_html($organizer_designation).'</span>';
                                                endif;
                                                ?>                          
                                            </div>
                                        </div><!--organizer end-->
                                        <div class="event-price">
                                            <?php  
                                            if (!empty($ticket_price)):
                                                echo '<span class="ticket-price">'.esc_html($ticket_price).'</span>';
                                            endif;
                                            if (!empty($ticket_btntext)):
                                                echo '<span class="ticket"><a href="'.esc_url($ticket_url).'">'.esc_html($ticket_btntext).'</a></span>';
                                            endif;
                                            ?>                 
                                        </div><!--event-price end-->
                                    </div><!--organizer-ticket end-->
                                </div><!--event-content end-->
                            </div><!--event-item-inner end-->
                        </div><!--event-item end-->                    
                    </div>                
                    <?php 
                    endwhile; wp_reset_postdata();
                    if( $pagination == 'yes' ) : ?>
                        <div class="col-md-12">
                          <div class="pagination-area text-center">

                            <?php
                            $total = $events->max_num_pages;
                            $args = array(
                              'total'       => $total,
                              'current'     => $paged,
                              'prev_text'   => __('«'),
                              'next_text'   => __('»'),
                              'type'        => 'list'
                            );
                            echo paginate_links( $args );
                            ?>
                          </div><!-- /.pagination-area -->
                        </div><!-- .col-md-12 -->
                        <?php
                    endif;
                endif; 
                ?>      
            </div>
            </div><!-- /.container -->
        </div><!-- /.container -->
	</div>
	<!-- end campaign-program section -->
<?php }