<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_event_schedule_1( $unique_id, $bg_image, $bg_color, $event_schedule, $color_selection, $title, $subtitle, $be_class ) {
	$bg_image = wp_get_attachment_url( $bg_image );
	if( $event_schedule == '2' ) :
		$event_schedule = ' schedules-three';
	elseif( $event_schedule == '3' ) :
		$event_schedule = ' schedules-two';
	elseif( $event_schedule == '4' ) :
		$event_schedule = ' schedules-seven';
	else :
		$event_schedule = '';
	endif;


	if( $color_selection == '2' ) :
		$color = ' schedules-six';
	elseif( $color_selection == '3' ) :
		$color = ' schedules-five';
	else :
		$color = ' ';
	endif;

?>
<!-- Schedules start here -->
<section id="schedules<?php echo esc_attr( $unique_id ); ?>" class="schedules <?php echo ( empty( $bg_image ) ) ? ' padding-120' : ''; echo esc_attr( $color ); echo esc_attr( $event_schedule ); echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>; background-image: url( <?php echo esc_url( $bg_image ); ?> )">

	<?php if( ! empty( $bg_image ) ) : ?>
	<div class="overlay">
	<?php endif; ?>

	  <div class="container">
	  
		    <?php
		    if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>

		    <div class="section-header text-center">

		    	<?php
		    	if( ! empty( $title ) ) :

		    		echo '<h3>' . esc_html( $title ) . '</h3>';

		    	endif; ?>

		    	<?php
		    	if( ! empty( $subtitle ) ) :

		    		echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';

		    	endif; ?>
		        
		    </div>

		    <?php endif; ?>

		<?php
		$be_event_schedules = '';
		if( function_exists( 'cs_get_option' ) ) :
			$be_event_schedules = cs_get_option( 'be_event_schedules' );
		?>
	    <div class="schedule-tabs">

		<?php if( $be_event_schedules ) : $i = 1; ?>
	      <!-- Nav tabs -->
	      <ul class="nav nav-tabs" role="tablist">

	      	<?php foreach( $be_event_schedules as $be_event_schedule ) : ?>

		        <li role="presentation" <?php echo ( $i == 1 ) ? 'class="active"' : ''; ?>>
			        <a href="#day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" aria-controls="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" role="tab" data-toggle="tab">
			          <?php echo esc_html( $be_event_schedule['event_day'] ); ?>
			          <span><?php echo esc_html( $be_event_schedule['event_date'] ); ?> <?php echo esc_html( $be_event_schedule['event_month'] ); ?> <?php echo esc_html( $be_event_schedule['event_year'] ); ?></span>
			        </a>
		        </li>

			<?php $i++; endforeach; ?>
	      </ul>
	     <?php endif; ?>

	      <!-- Tab panes -->
	      <div class="tab-content">
			<?php
			if( $be_event_schedules ) :
			$i = 1;
			foreach( $be_event_schedules as $be_event_schedule ) : 
            ?>

	        <div role="tabpanel" class="tab-pane<?php echo ( $i == 1 ) ? ' in' : ''; echo ( $i == 1 ) ? ' active' : ''; ?>" id="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>">
	          <div class="schedule-table table-responsive">
	            <table>
	              <thead>
	                <tr>
	                  <th class="time"><?php _e( 'Time', 'big-event' ); ?></th>
	                  <th class="session"><?php _e( 'Session', 'big-event' ); ?></th>
	                  <th class="spekers"><?php _e( 'Speakers', 'big-event' ); ?></th>
	                  <th class="venue"><?php _e( 'Venue', 'big-event' ); ?></th>
	                </tr>
	              </thead>
	              <tbody>
					<?php
					$be_event_schedules = cs_get_option( 'be_per_date_schedules_' . $i );
					if( $be_event_schedules ) :
					foreach( $be_event_schedules as $be_event_schedule ) : ?>

	                <tr>
                        <td class="time"><span><i class="fa fa-clock-o" aria-hidden="true"></i></span><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_time'] ); ?></td>
                        <td class="session"><span><i class="fa fa-list-alt" aria-hidden="true"></i></span>                          
                            <?php
                            if(!empty($be_event_schedule['surl'])) :
                                echo '<a href="'.esc_url($be_event_schedule['surl']).'">'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</a>';
                            else:
                                echo esc_html( $be_event_schedule['be_event_per_date_schedules_session'] );
                            endif;                           
                            ?>
                        </td>
                        <td class="spekers">
                          <span>
                              <i class="fa fa-microphone" aria-hidden="true"></i>
                          </span>
                          <?php
                          if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
                          $speakers = new WP_Query( array(
                              'post_type'		=> 'speakers',
                              'post__in'		=> @$be_event_schedule['be_event_per_date_schedules_speaker']
                          ) );
                          if( $speakers->have_posts() ) :

                              while( $speakers->have_posts() ) : $speakers->the_post(); ?>

                              <a href="<?php echo get_the_permalink(); ?>">
                                  <?php the_title(); ?>
                              </a>

                          <?php endwhile; endif; endif; ?>
                        </td>

                        <td class="venue"><span><i class="fa fa-home" aria-hidden="true"></i></span><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_venue'] ); ?></td>
	                </tr>

					<?php endforeach; endif; ?>
	              </tbody>
	            </table>
	          </div><!-- schedule-table -->

	        </div>

			<?php $i++; endforeach; endif; ?>

	      </div>
	    </div>
	    <?php endif; ?>
	  </div><!-- container -->
	<?php if( ! empty( $bg_image ) ) : ?>
	</div>
	<?php endif; ?>
</section><!-- schedules -->
<!-- Schedules end here -->
<?php }