<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_event_schedule_1 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'unique_id'			=> '',
			'bg_image'			=> '',
			'bg_color'			=> '',
			'event_schedule'	=> '',
			'color_selection'	=> '',
			'title'				=> '',
			'subtitle'			=> '',
			'be_class'			=> ''
		), $atts ) );
		ob_start();
			big_event_event_schedule_1( $unique_id, $bg_image, $bg_color, $event_schedule, $color_selection, $title, $subtitle, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Event Schedule', 'big-event' ),
	'base'			=> 'big_event_event_schedule_1',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Unique ID', 'big-event' ),
			'param_name'	=> 'unique_id',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Event Schedule', 'big-event' ),
			'param_name'	=> 'event_schedule',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
			'value'		=> array(
				esc_html__( 'Select Event Schedule', 'big-event' )	=> '',
				esc_html__( 'Event Schedule One', 'big-event' )		=> '1',
				esc_html__( 'Event Schedule Two', 'big-event' )		=> '2',
				esc_html__( 'Event Schedule Three', 'big-event' )	=> '3',
				esc_html__( 'Event Schedule Four', 'big-event' )	=> '4'
			)
		),
		array(
			'type'			=> 'dropdown',
			'heading'		=> esc_html__( 'Color Selection', 'big-event' ),
			'param_name'	=> 'color_selection',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
			'value'		=> array(
				esc_html__( 'Select Color', 'big-event' )	=> '',
				esc_html__( 'Color One', 'big-event' )		=> '1',
				esc_html__( 'Color Two', 'big-event' )		=> '2',
				esc_html__( 'Color Three', 'big-event' )	=> '3'
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
		)
	)
) );
endif;