<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.4.1
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_schedule_8 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
            extract( shortcode_atts( array(
                    'unique_id'			=> '',                   
                    'title'             => '',
                    'subtitle'			=> '',
                    'col_limit'			=> '3',
                    'be_class'			=> ''
            ), $atts ) );
            ob_start();
            big_event_event_schedule_8( $unique_id, $title, $subtitle, $col_limit, $be_class );
            return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Event Schedule 8', 'big-event' ),
	'base'			=> 'big_event_schedule_8',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Unique ID', 'big-event' ),
			'param_name'	=> 'unique_id',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
            "description"   => esc_html__( "Schedule from first date will only display by this shortcode", 'big-event' )
		),
        array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Column Limit', 'big-event' ),
			'param_name'	=> 'col_limit',
            'std'           => '3',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
		)
	)
) );
endif;


function big_event_event_schedule_8( $unique_id, $title, $subtitle, $col_limit, $be_class ) {
    $css_classes = array(
        'schedules',
        'schedules-15',
        'padding-120',
        $be_class,
    );
    $css_class = implode( ' ', array_filter( array_unique( $css_classes ) ) );
?>
<!-- Schedules start here -->
<section id="schedules<?php echo esc_attr( $unique_id ); ?>" class="<?php echo esc_attr($css_class); ?>">
    <div class="container">	  
        <?php
        if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>
        <div class="section-header text-center">
            <?php
            if( ! empty( $title ) ) :
                echo '<h3>' . esc_html( $title ) . '</h3>';
            endif;

            if( ! empty( $subtitle ) ) :
                echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
            endif; 
            ?>		        
        </div>
        <?php endif; ?>

        
        <?php
        $be_event_schedules = '';
        if( function_exists( 'cs_get_option' ) ) :
            $be_event_schedules = cs_get_option( 'be_event_schedules' );
        ?>
        <div class="section-wrapper">
            <div class="row">
                <?php
                
                $i = 0;
                if (!empty($be_event_schedules)):
                $count = count($be_event_schedules);                
                foreach( $be_event_schedules as $be_event_schedule ) : $i++;                    
                ?>
                <div class="col-sm-6 col-md-4">
                    <div class="schedule-item">
                        <div class="schedule-item-head">
                            <h5><?php echo esc_html( $be_event_schedule['event_day'] ); ?></h5>
                            <p><?php echo esc_html( $be_event_schedule['event_date'] ) .' '. esc_html( $be_event_schedule['event_month'] ) .' '. esc_html( $be_event_schedule['event_year'] ) ?></p>
                        </div>
                        <div class="schedule-item-wrapper">
                            <?php
                            $be_event_schedules = cs_get_option( 'be_per_date_schedules_' . $i );
                            if( $be_event_schedules ) :
                            foreach( $be_event_schedules as $be_event_schedule ) :
                            ?>
                            <div class="siw-item">
                                <?php
                                if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
                                $speakers = new WP_Query( array(
                                        'post_type'		=> 'speakers',
                                        'post__in'		=> @$be_event_schedule['be_event_per_date_schedules_speaker']
                                ) );
                                endif;   
                                if( $speakers->have_posts() ) :
                                    while( $speakers->have_posts() ) : $speakers->the_post(); 
                                        if (function_exists('cs_get_option')) :
                                            $be_speakers_post_options = get_post_meta(get_the_ID(), '_be_speakers_post_options', true);
                                            $be_speakers_designation = isset($be_speakers_post_options['be_speakers_designation']) ? $be_speakers_post_options['be_speakers_designation'] : '';
                                        endif;
                                        if(has_post_thumbnail()):
                                            echo '<div class="siw-item-thumb">'; 
                                            the_post_thumbnail('thumbnail');
                                            echo '</div>';    
                                        endif;                                    
                                    endwhile; 
                                endif; 
                                ?>
                                <div class="siw-item-content">
                                    <p class="time"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_time'] ); ?></p>
                                    <p>
                                        <?php
                                        if(!empty($be_event_schedule['surl'])) :
                                            echo '<a href="'.esc_url($be_event_schedule['surl']).'">'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</a>';
                                        else:
                                            echo esc_html( $be_event_schedule['be_event_per_date_schedules_session'] );
                                        endif;                           
                                        ?>                                        
                                    </p>
                                    <p class="location"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_venue'] ); ?></p>
                                </div>
                            </div>
                            <?php endforeach; endif; ?>                            
                        </div>
                    </div>
                </div>                
                <?php if($i==$col_limit) break; endforeach; endif; ?>
          </div>
        </div>
        <?php endif; ?>        
        
                
    </div><!-- container -->
</section><!-- schedules -->
<!-- Schedules end here -->
<?php }