<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.4.2
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_event_schedule_7 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
            extract( shortcode_atts( array(
                    'unique_id'			=> '',
                    'bg_image'			=> '',
                    'bg_color'			=> '#17202A',                    
                    'title'				=> '',
                    'subtitle'			=> '',
                    'be_class'			=> ''
            ), $atts ) );
            ob_start();
            big_event_event_schedule_7( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class );
            return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Event Schedule 7', 'big-event' ),
	'base'			=> 'big_event_event_schedule_7',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event Dark', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Unique ID', 'big-event' ),
			'param_name'	=> 'unique_id',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
		)
	)
) );
endif;

function big_event_event_schedule_7( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class ) {
	$bg_image = wp_get_attachment_url( $bg_image );
    $css_classes = array(
        'schedules-17',
        'dark-overlay-left',
        'schedules',
        'schedules-uhv',
        $be_class,
    );
    $css_class = implode( ' ', array_filter( array_unique( $css_classes ) ) );
?>
<!-- Schedules start here -->
<section class="dark-layout">
	<div id="schedules<?php echo esc_attr( $unique_id ); ?>" class="<?php echo esc_attr($css_class); ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>; background-image: url( <?php echo esc_url( $bg_image ); ?> )">

		<?php if( ! empty( $bg_image ) ) : ?>
		<div class="overlay padding-120">
		<?php endif; ?>

		  <div class="container">
		  
			    <?php
			    if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>

			    <div class="section-header text-center">

			    	<?php
			    	if( ! empty( $title ) ) :

			    		echo '<h3>' . esc_html( $title ) . '</h3>';

			    	endif; ?>

			    	<?php
			    	if( ! empty( $subtitle ) ) :

			    		echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';

			    	endif; ?>
			        
			    </div>

			    <?php endif; ?>

			<?php
			$be_event_schedules = '';
			if( function_exists( 'cs_get_option' ) ) :
				$be_event_schedules = cs_get_option( 'be_event_schedules' );
			?>
		    <div class="schedule-tabs">

			<?php if( $be_event_schedules ) : $i = 1; ?>
		      <!-- Nav tabs -->
		      <ul class="nav nav-tabs" role="tablist">

		      	<?php foreach( $be_event_schedules as $be_event_schedule ) : ?>

			        <li role="presentation" <?php echo ( $i == 1 ) ? 'class="active"' : ''; ?>>
				        <a href="#day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" aria-controls="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" role="tab" data-toggle="tab">
				          <?php echo esc_html( $be_event_schedule['event_date'] ); ?> <?php echo esc_html( $be_event_schedule['event_month'] ); ?> <?php echo esc_html( $be_event_schedule['event_year'] ); ?>
				        </a>
			        </li>

				<?php $i++; endforeach; ?>
		      </ul>
		     <?php endif; ?>

		      <!-- Tab panes -->
		      <div class="tab-content">
	                <?php
	                if( $be_event_schedules ) :
	                $i = 1;
                    if (!empty($be_event_schedules)):
	                foreach( $be_event_schedules as $be_event_schedule ) :                              
	                ?>

		        <div role="tabpanel" class="tab-pane<?php echo ( $i == 1 ) ? ' in' : ''; echo ( $i == 1 ) ? ' active' : ''; ?>" id="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>">
	                    <div class="schedule-list">
	                        <?php
	                        $be_event_schedules = cs_get_option( 'be_per_date_schedules_' . $i );
                            
	                        if( $be_event_schedules ) :
                            $m = 0;
	                        foreach( $be_event_schedules as $be_event_schedule ) : $m++;
                                $be_epds_image = $be_event_schedule['be_epds_image'];
                                $be_epds_small_image = wp_get_attachment_image_src( $be_epds_image, 'big-event-280-120' );
                                $be_epds_full_image = wp_get_attachment_image_src( $be_epds_image, 'big-event-blog-image' );
                                $be_epds_detail = $be_event_schedule['be_epds_detail'];
                                $mid = $m.$i;
	                        ?>   
                            <div class="col-xs-6 col-sm-4 col-md-3">
                                <div class="schedule-item">
                                    <div class="schedule-thumb-outer">
                                        <?php if (!empty($be_epds_image)): ?>
                                        <div class="schedule-thumb">
                                            <img src="<?php echo esc_url($be_epds_small_image[0]) ?>" alt="">
                                        </div>
                                        <div class="open-schedule-modal large-image"  data-toggle="modal" data-target="#myModal<?php echo esc_attr($mid)?>">
                                            <img src="<?php echo get_template_directory_uri() ?>/images/expand-icon.png" alt="">
                                        </div>
                                        <?php endif; ?>
                                    </div>                                  
                                    <!-- Modal -->
                                    <div class="modal fade" id="myModal<?php echo esc_attr($mid)?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                                        <div class="modal-content">
                                            <div class="event-item">
                                                <?php if (!empty($be_epds_image)): ?>
                                                <div class="event-thumb">
                                                    <img src="<?php echo esc_url($be_epds_full_image[0]) ?>" alt="">
                                                </div>
                                                <?php endif; ?>
                                                <?php if (!empty($be_epds_detail)): ?>
                                                <div class="event-content">
                                                    <?php echo '<h3>'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</h3>' ?>
                                                    <?php echo wp_kses_post($be_epds_detail) ?>
                                                </div>
                                                <?php endif; ?>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            </div>
                                        </div>
                                    </div>                                    
                                    <div class="schedule-content">
                                        <?php
                                        if(!empty($be_event_schedule['be_event_per_date_schedules_time'])):
                                            echo '<p class="time">'.esc_html( $be_event_schedule['be_event_per_date_schedules_time'] ).'</p>';
                                        endif;
                                        if(!empty($be_event_schedule['be_event_per_date_schedules_session']) && !empty($be_epds_detail)):
                                            echo '<p class="session-title" data-toggle="modal" data-target="#myModal'.esc_attr($mid).'">'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</p>';
                                        elseif (!empty($be_event_schedule['be_event_per_date_schedules_session'])):
                                            echo '<p>'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</p>';
                                        endif;
                                        if(!empty($be_event_schedule['be_event_per_date_schedules_venue'])):
                                            echo '<p class="time">'.esc_html( $be_event_schedule['be_event_per_date_schedules_venue'] ).'</p>';
                                        endif;
                                        ?>
                                        <?php  ?>
                                        <?php  ?>
                                    </div>
                                </div>                                  
                            </div>                                                        	                        
	                        <?php endforeach; endif; ?>
		          </div><!-- schedule-table -->

		        </div>

	                <?php $i++; endforeach; endif; endif; ?>

		      </div>
		    </div>
		    <?php endif; ?>
		  </div><!-- container -->
		<?php if( ! empty( $bg_image ) ) : ?>
		</div>
		<?php endif; ?>
	</div><!-- schedules -->
</section>
<!-- Schedules end here -->
<?php }