<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.3.2
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_event_schedule_5 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
        extract( shortcode_atts( array(
                'unique_id'			=> '',
                'bg_image'			=> '',
                'bg_color'			=> '#17202A',                    
                'title'				=> '',
                'subtitle'			=> '',
                'be_class'			=> ''
        ), $atts ) );
        ob_start();
        big_event_event_schedule_5( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class );
        return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Event Schedule 5', 'big-event' ),
	'base'			=> 'big_event_event_schedule_5',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Unique ID', 'big-event' ),
			'param_name'	=> 'unique_id',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
		)
	)
) );
endif;


function big_event_event_schedule_5( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class ) {
	$bg_image = wp_get_attachment_url( $bg_image );             
?>
<!-- Schedules start here -->
<div id="schedules<?php echo esc_attr( $unique_id ); ?>" class="schedules schedules-uhv schedules-5<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>; background-image: url( <?php echo esc_url( $bg_image ); ?> )">

    <?php if( ! empty( $bg_image ) ) : ?>
    <div class="padding-120 overlay">
    <?php endif; ?>

      <div class="container">

            <?php
            if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>

            <div class="section-header text-center">
                <?php
                if( ! empty( $title ) ) :
                    echo '<h3>' . esc_html( $title ) . '</h3>';
                endif;
                
                if( ! empty( $subtitle ) ) :
                    echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';
                endif; 
                ?>
            </div>

            <?php endif; ?>

        <?php
        $be_event_schedules = '';
        if( function_exists( 'cs_get_option' ) ) :
            $be_event_schedules = cs_get_option( 'be_event_schedules' );
        ?>
        <div class="schedule-tabs">

        <?php if( $be_event_schedules ) : $i = 1; ?>
          <!-- Nav tabs -->
          <ul class="nav nav-tabs" role="tablist">

            <?php foreach( $be_event_schedules as $be_event_schedule ) : ?>

                <li role="presentation" <?php echo ( $i == 1 ) ? 'class="active"' : ''; ?>>
                    <a href="#day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" aria-controls="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" role="tab" data-toggle="tab">
                      <?php echo esc_html( $be_event_schedule['event_date'] ); ?> <?php echo esc_html( $be_event_schedule['event_month'] ); ?> <?php echo esc_html( $be_event_schedule['event_year'] ); ?>
                    </a>
                </li>

            <?php $i++; endforeach; ?>
          </ul>
         <?php endif; ?>

          <!-- Tab panes -->
          <div class="tab-content">
                <?php
                if( $be_event_schedules ) :
                $i = 1;
                if (!empty($be_event_schedules)):
                foreach( $be_event_schedules as $be_event_schedule ) :                              
                ?>

                <div role="tabpanel" class="tab-pane<?php echo ( $i == 1 ) ? ' in' : ''; echo ( $i == 1 ) ? ' active' : ''; ?>" id="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>">
                    <div class="schedule-list">
                        <?php
                        $j = 0;
                        $be_event_schedules = cs_get_option( 'be_per_date_schedules_' . $i );
                        if( $be_event_schedules ) :
                        foreach( $be_event_schedules as $be_event_schedule ) : $j++;
                            if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
                            $speakers = new WP_Query( array(
                                    'post_type'		=> 'speakers',
                                    'post__in'		=> @$be_event_schedule['be_event_per_date_schedules_speaker']
                            ) );
                            endif;
                        ?>                        
                        <div class="col-xs-6 col-md-3">
                            <div class="schedule-item bg-clr">

                                <?php 
                                if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
                                    if( $speakers->have_posts() ) :
                                        while( $speakers->have_posts() ) : $speakers->the_post(); 
                                        if (function_exists('cs_get_option')) :
                                            $be_speakers_post_options = get_post_meta(get_the_ID(), '_be_speakers_post_options', true);
                                            $be_speakers_designation = isset($be_speakers_post_options['be_speakers_designation']) ? $be_speakers_post_options['be_speakers_designation'] : '';
                                        endif;
                                    ?>
                                            <div class="schedule-speader"> 
                                                <?php
                                                if(has_post_thumbnail()):
                                                    echo '<div class="speaker-thumb">'; 
                                                    the_post_thumbnail('thumbnail');
                                                    echo '</div>';    
                                                endif;
                                                ?>
                                                <div class="author-name">
                                                    <span class="speaker-name"><a href="<?php echo the_permalink()?>"><?php the_title() ?></a></span>
                                                    <?php 
                                                    if (!empty($be_speakers_designation)):
                                                        echo '<p class="designation">'.$be_speakers_designation.'</p>';
                                                    endif;
                                                    ?>                                                    
                                                </div> 
                                            </div>
                                            <?php
                                        endwhile; 
                                    endif;
                                endif;
                                ?>
                                <div class="schedule-content">
                                    <span class="time"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_time'] ); ?></span>
                                    <p class="session">
                                        <?php
                                        if(!empty($be_event_schedule['surl'])) :
                                            echo '<a href="'.esc_url($be_event_schedule['surl']).'">'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</a>';
                                        else:
                                            echo esc_html( $be_event_schedule['be_event_per_date_schedules_session'] );
                                        endif;                                         
                                        ?>
                                    </p>
                                    <span class="hall"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_venue'] ); ?></span>
                                </div>
                            </div>
                        </div> 
                        <?php
                        if ($j % 4 == 0):
                            echo '<div class="clearfix"></div>';
                        endif;
                        endforeach; endif; 
                        ?>
                </div><!-- schedule-table -->

            </div>

                <?php $i++; endforeach; endif; endif; ?>

          </div>
        </div>
        <?php endif; ?>
      </div><!-- container -->
    <?php if( ! empty( $bg_image ) ) : ?>
    </div>
    <?php endif; ?>
</div><!-- schedules -->
<!-- Schedules end here -->
<?php }