<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_event_schedule_4( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class ) {
	$bg_image = wp_get_attachment_url( $bg_image );              
?>
<!-- Schedules start here -->
<section id="schedules<?php echo esc_attr($unique_id); ?>" class="schedules schedules-4<?php echo ( $be_class ) ? ' ' . esc_attr($be_class) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>; background-image: url( <?php echo esc_url( $bg_image ); ?> )">
    <div class="overlay padding-120">
        <div class="container">
            <?php if (!empty($title) || !empty($subtitle)) : ?>
                <div class="section-header text-center">
                    <?php
                    if (!empty($title)) :
                        echo '<h3>' . esc_html($title) . '</h3>';
                    endif;

                    if (!empty($subtitle)) :
                        echo '<p><em>' . esc_html($subtitle) . '</em></p>';
                    endif;
                    ?>
                </div>
            <?php endif; ?>
            
            <div class="section-wrapper">
                <?php 
                if( function_exists( 'cs_get_option' ) ) :
                    $j = 0;
	                $be_event_schedules = cs_get_option( 'be_per_date_schedules_1');
                    foreach( $be_event_schedules as $be_event_schedule ) : $j++;
                    if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
                    $speakers = new WP_Query( array(
                        'post_type'		=> 'speakers',
                        'post__in'		=> @$be_event_schedule['be_event_per_date_schedules_speaker']
                    ));   
                    endif;
                ?>
                <div class="schedule-item">
                    <div class="schedule-item-inner">
                        <?php if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])): ?>
                        <div class="schedule-heading">
                            <?php                             
                            if( $speakers->have_posts() ) :
                                while( $speakers->have_posts() ) : $speakers->the_post();
                                $be_speakers_post_options = get_post_meta( get_the_ID(), '_be_speakers_post_options', true );
                                $be_speakers_designation  = isset( $be_speakers_post_options['be_speakers_designation'] ) ? $be_speakers_post_options['be_speakers_designation'] : '';
                                    if(has_post_thumbnail()):
                                        echo '<div class="speaker-pic">'; 
                                        the_post_thumbnail('thumbnail');
                                        echo '</div>';    
                                    endif; 
                                    ?>
                                <div class="speaker-name">
                                    <h6><a href="<?php echo the_permalink() ?>"><?php the_title() ?></a></h6>
                                    <p><?php echo esc_html($be_speakers_designation) ?></p>
                                </div>
                            <?php endwhile; endif; ?>
                        </div>
                        <?php endif; ?>

                        <div class="schedule-content">
                            <p class="time"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_time'] ); ?></p>
                            <p>
                                <?php
                                if(!empty($be_event_schedule['surl'])) :
                                    echo '<a href="'.esc_url($be_event_schedule['surl']).'">'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</a>';
                                else:
                                    echo esc_html( $be_event_schedule['be_event_per_date_schedules_session'] );
                                endif;                                         
                                ?>
                            </p>
                            <p class="venue"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_venue'] ); ?></p>
                        </div>
                    </div>
                </div>   
                <?php 
                if ($j % 4 == 0):
                    echo '<div class="clearfix"></div>';
                endif;                
                endforeach; endif; 
                ?>
            </div>
        </div><!-- container -->
    </div>
</section><!-- schedules -->
<!-- Schedules end here -->
<?php }