<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_schedule_4 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
            extract( shortcode_atts( array(
                    'unique_id'			=> '',
                    'bg_image'			=> '',
                    'bg_color'			=> '',                    
                    'title'			=> '',
                    'subtitle'			=> '',
                    'be_class'			=> ''
            ), $atts ) );
            ob_start();
            big_event_event_schedule_4( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class );
            return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Event Schedule 4', 'big-event' ),
	'base'			=> 'big_event_schedule_4',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Unique ID', 'big-event' ),
			'param_name'	=> 'unique_id',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),
		array(
			'type'			=> 'colorpicker',
			'heading'		=> esc_html__( 'Section Background Color', 'big-event' ),
			'param_name'	=> 'bg_color',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' )
		),		
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'subtitle',
			'group'			=> esc_html__( 'Event Schedule', 'big-event' ),
            "description"   => esc_html__( "Schedule from first date will only display by this shortcode", 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
		)
	)
) );
endif;