<?php
/**
 * Big Event Event Schedule
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_event_schedule_3( $unique_id, $bg_image, $bg_color, $title, $subtitle, $be_class ) {
	$bg_image = wp_get_attachment_url( $bg_image );             
?>
<!-- Schedules start here -->
<section class="dark-layout">
	<div id="schedules<?php echo esc_attr( $unique_id ); ?>" class="dark-overlay-left schedules schedules-uhv schedules-3<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>; background-image: url( <?php echo esc_url( $bg_image ); ?> )">

		<?php if( ! empty( $bg_image ) ) : ?>
		<div class="overlay padding-120">
		<?php endif; ?>

		  <div class="container">
		  
			    <?php
			    if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>

			    <div class="section-header text-center">

			    	<?php
			    	if( ! empty( $title ) ) :

			    		echo '<h3>' . esc_html( $title ) . '</h3>';

			    	endif; ?>

			    	<?php
			    	if( ! empty( $subtitle ) ) :

			    		echo '<p><em>' . esc_html( $subtitle ) . '</em></p>';

			    	endif; ?>
			        
			    </div>

			    <?php endif; ?>

			<?php
			$be_event_schedules = '';
			if( function_exists( 'cs_get_option' ) ) :
				$be_event_schedules = cs_get_option( 'be_event_schedules' );
			?>
		    <div class="schedule-tabs">

			<?php if( $be_event_schedules ) : $i = 1; ?>
		      <!-- Nav tabs -->
		      <ul class="nav nav-tabs" role="tablist">

		      	<?php foreach( $be_event_schedules as $be_event_schedule ) : ?>

			        <li role="presentation" <?php echo ( $i == 1 ) ? 'class="active"' : ''; ?>>
				        <a href="#day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" aria-controls="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>" role="tab" data-toggle="tab">
				          <?php echo esc_html( $be_event_schedule['event_date'] ); ?> <?php echo esc_html( $be_event_schedule['event_month'] ); ?> <?php echo esc_html( $be_event_schedule['event_year'] ); ?>
				        </a>
			        </li>

				<?php $i++; endforeach; ?>
		      </ul>
		     <?php endif; ?>

		      <!-- Tab panes -->
		      <div class="tab-content">
	                <?php
	                if( $be_event_schedules ) :
	                $i = 1;
                    if (!empty($be_event_schedules)):
	                foreach( $be_event_schedules as $be_event_schedule ) :                              
	                ?>

		        <div role="tabpanel" class="tab-pane<?php echo ( $i == 1 ) ? ' in' : ''; echo ( $i == 1 ) ? ' active' : ''; ?>" id="day<?php echo esc_attr( $i ); echo esc_attr( $unique_id ); ?>">
	                    <div class="schedule-list">
	                        <?php
	                        $be_event_schedules = cs_get_option( 'be_per_date_schedules_' . $i );
	                        if( $be_event_schedules ) :
	                        foreach( $be_event_schedules as $be_event_schedule ) : 
                                if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
	                            $speakers = new WP_Query( array(
	                                    'post_type'		=> 'speakers',
	                                    'post__in'		=> @$be_event_schedule['be_event_per_date_schedules_speaker']
	                            ) );
                                endif;
	                        ?>                        
	                        <div class="col-md-6">
	                            <div class="schedule-item">
	                                
	                                <?php 
                                    if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):
                                        if( $speakers->have_posts() ) :
                                            while( $speakers->have_posts() ) : $speakers->the_post();
                                                if(has_post_thumbnail()):
                                                    echo '<div class="schedule-speader">'; 
                                                    the_post_thumbnail('thumbnail');
                                                    echo '</div>';    
                                                endif;                                            
                                            endwhile; 
                                        endif;
                                    endif;
	                                ?>                                    
	                                

	                                <div class="schedule-content">
	                                    <div class="schedule-heading">
	                                        <span class="time pull-left"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_time'] ); ?></span>
	                                        <span class="hall pull-right"><?php echo esc_html( $be_event_schedule['be_event_per_date_schedules_venue'] ); ?></span>
	                                    </div>
                                        <h6 class="session">
                                            <?php
                                            if(!empty($be_event_schedule['surl'])) :
                                                echo '<a href="'.esc_url($be_event_schedule['surl']).'">'.esc_html( $be_event_schedule['be_event_per_date_schedules_session'] ).'</a>';
                                            else:
                                                echo esc_html( $be_event_schedule['be_event_per_date_schedules_session'] );
                                            endif;                                         
                                            ?>
                                        </h6>
	                                    <?php if (!empty($be_event_schedule['be_event_per_date_schedules_speaker'])):?>
	                                    <span class="speaker-name"><?php esc_html_e('By','big-event') ?>
	                                        <?php 
	                                            if( $speakers->have_posts() ) :
	                                            while( $speakers->have_posts() ) : $speakers->the_post();
	                                                echo '<a href="'. get_the_permalink().'">'.get_the_title().'</a>';
	                                            endwhile; endif; 
	                                        ?>
	                                    </span>
                                        <?php endif; ?>
	                                </div>
	                            </div>
	                        </div> 
	                        <?php endforeach; endif; ?>
		          </div><!-- schedule-table -->

		        </div>

	                <?php $i++; endforeach; endif; endif; ?>

		      </div>
		    </div>
		    <?php endif; ?>
		  </div><!-- container -->
		<?php if( ! empty( $bg_image ) ) : ?>
		</div>
		<?php endif; ?>
	</div><!-- schedules -->
</section>
<!-- Schedules end here -->
<?php }