<?php
/**
 * Big Event Event Gallery
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_event_gallery( $bg_image, $title, $sub_title, $event_photos, $gallery_icon, $be_class ) {
	$bg_image 		= wp_get_attachment_url( $bg_image );
	$gallery_icon 	= wp_get_attachment_url( $gallery_icon );
	?>
    <!-- Gallery start here -->
    <section class="be-gallery be-gallery-six <?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-image: url( <?php echo esc_url( $bg_image ); ?> );">
      <div class="overlay home-six-overlay">
  
	    <?php
	    if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

	    <div class="section-header text-center">

	    	<?php
	    	if( ! empty( $title ) ) :

	    		echo '<h3>' . esc_html( $title ) . '</h3>';

	    	endif; ?>

	    	<?php
	    	if( ! empty( $sub_title ) ) :

	    		echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

	    	endif; ?>
	        
	    </div>

	    <?php endif; ?>

        <div class="be-gallery-items">
		<?php
		if( ! empty( $event_photos ) ) :

			foreach( $event_photos as $event_photo ) :
			$event_photo = wp_get_attachment_url( $event_photo['image'] );
			?>

	          <div class="be-gallery-item">
	            <div class="be-gallery-image ">
	              <img src="<?php echo esc_url( $event_photo ); ?>" alt="gallery image" class="img-responsive">
	                <div class="overlay"></div>
	                <a href="<?php echo esc_url( $event_photo ); ?>" data-rel="lightcase:myCollection">
	                  <img src="<?php echo esc_url( $gallery_icon ); ?>" alt="gallery icon" class="img-responsive">
	                </a>
	            </div>
	          </div><!-- gallery-item -->

      		<?php endforeach; ?>

      	<?php endif; ?>

        </div><!-- gallery-items -->
      </div><!-- overlay -->
    </section><!-- gallery -->
    <!-- Gallery end here -->
	<?php
}