<?php
/**
 * Big Event Gallery 01
 *
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_event_gallery extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bg_image'		=> '',
			'title'			=> '',
			'sub_title'		=> '',
			'event_photos'	=> '',
			'gallery_icon'	=> '',
			'be_class'		=> ''
		), $atts ) );
		$event_photos 	= ( array ) vc_param_group_parse_atts( $event_photos );
		ob_start();
			big_event_event_gallery( $bg_image, $title, $sub_title, $event_photos, $gallery_icon, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Event Gallery 01', 'big-event' ),
	'base'		=> 'big_event_event_gallery',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Background Image', 'big-event' ),
			'param_name'	=> 'bg_image',
			'group'			=> esc_html__( 'Event Gallery', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'Event Gallery', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'Event Gallery', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Event Photo', 'big-event' ),
			'param_name'	=> 'event_photos',
			'group'			=> esc_html__( 'Event Gallery', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Event Image', 'big-event' ),
					'param_name'	=> 'image'
				),
			)
		),
		array(
			'type'			=> 'attach_image',
			'heading'		=> esc_html__( 'Gallery Icon', 'big-event' ),
			'param_name'	=> 'gallery_icon',
			'group'			=> esc_html__( 'Event Gallery', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;