<?php
/**
 * Big Event Event gallery 2 Shortcode
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_event_gallery_4 extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title'			=> '',
			'sub_title'		=> '',
			'event_photos'	=> '',
			'be_class'		=> ''
		), $atts ) );
		$event_photos 	= ( array ) vc_param_group_parse_atts( $event_photos );
		ob_start();
			big_event_event_gallery_4( $title, $sub_title, $event_photos, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Event Gallery 04', 'big-event' ),
	'base'		=> 'big_event_event_gallery_4',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Event Photos', 'big-event' ),
			'param_name'	=> 'event_photos',
			'group'			=> esc_html__( 'Gallery', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Image', 'big-event' ),
					'param_name'	=> 'image',
                    'description'	=> esc_html__( 'Recommended image size 330*270', 'big-event' )
				),
                array(
                    'type'			=> 'textfield',
                    'heading'		=> esc_html__( 'Title', 'big-event' ),
                    'param_name'	=> 'title',
                ),
                array(
                    'type'			=> 'colorpicker',
                    'heading'		=> esc_html( 'Color', 'big-event' ),
                    'param_name'	=> 'color',
                    'std'           => '#db0e0b',
                ),
                array(
                    'type'			=> 'textfield',
                    'heading'		=> esc_html__( 'URL', 'big-event' ),
                    'param_name'	=> 'url',
                ),
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_event_gallery_4( $title, $sub_title, $event_photos, $be_class ) {    
    $css_classes = array(
        'multi-gallery-section',
        'padding-120'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
	?>
    <!-- Gallery start here -->
    <section class="<?php echo implode( ' ', $css_classes ) ?>">
        <div class="container">
            <div class="row">
                <?php if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

                <div class="section-header text-center">

                    <?php
                    if( ! empty( $title ) ) :

                        echo '<h3>' . esc_html( $title ) . '</h3>';

                    endif; ?>

                    <?php
                    if( ! empty( $sub_title ) ) :

                        echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

                    endif; ?>

                </div>

                <?php endif; ?>
                <div class="section-wrapper">
                    <?php
                    if( ! empty( $event_photos ) ) :
                        foreach( $event_photos as $event_photo ) :
                        $event_photo_url = wp_get_attachment_url( $event_photo['image'] );
                        $event_photo_alt = get_post_meta($event_photo['image'], '_wp_attachment_image_alt', true);
                        if(!empty($event_photo['color'])):
                            $titlecolor = 'style="color: '.esc_attr($event_photo['color']).'"';
                            $overlay = big_event_hex2rgba($event_photo['color'], .8);
                            $overlaycolor = 'style="background-color: '.esc_attr($overlay).'"';
                        endif;

                    ?>
                    <div class="col-md-4 col-sm-6">
                        <div class="gallery-item">
                            <span></span>
                            <div class="gallery-item-inner">
                                <div class="gallery-thumb">
                                    <img src="<?php echo esc_url( $event_photo_url ); ?>" alt="<?php echo esc_attr($event_photo_alt) ?>">
                                    <div class="gallery-thumb-ovarlay" <?php echo $overlaycolor; ?>></div>
                                    <a href="" class="gallery-icon">
                                      <i class="fa fa-camera" aria-hidden="true"></i>
                                    </a>
                                </div>
                                <div class="gallery-title">
                                    <?php 
                                    if (!empty($event_photo['title'])):
                                        echo '<h4 '.$titlecolor.'>'.esc_html($event_photo['title']).'</h4>';
                                    endif;
                                    ?>
                                </div>
                            </div>                        
                        </div><!-- gallery-item -->
                    </div><!-- gallery-item -->
                    <?php endforeach; endif; ?>
                </div>
            </div><!-- row -->
        </div><!-- container -->
    </section><!-- gallery -->
    <!-- Gallery end here -->
	<?php
}