<?php
/**
 * Big Event Event Gallery
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_event_gallery_3( $bg_image, $title, $sub_title, $event_photos, $gallery_icon, $gallery_btn_text, $gallery_btn_url, $gallery_btn_color, $gallery_btn_bgc, $be_class ) {
	$bg_image 		= wp_get_attachment_url( $bg_image );
	$gallery_icon 	= wp_get_attachment_url( $gallery_icon );
	?>
    <!-- Gallery start here -->
    <section class="be-gallery <?php echo ( empty( $bg_image ) ) ? ' padding-120 be-gallery-about' : ''; echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-image: url( <?php echo esc_url( $bg_image ); ?> );">

      <?php if( ! empty( $bg_image ) ) : ?>
      <div class="overlay">
  	  <?php endif; ?>
        <div class="container">
  
	    <?php
	    if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

	    <div class="section-header text-center">

	    	<?php
	    	if( ! empty( $title ) ) :

	    		echo '<h3>' . esc_html( $title ) . '</h3>';

	    	endif; ?>

	    	<?php
	    	if( ! empty( $sub_title ) ) :

	    		echo '<p><em>' . esc_html( $sub_title ) . '</em></p>';

	    	endif; ?>
	        
	    </div>

	    <?php endif; ?>

          <div class="row">
                <?php
                if( ! empty( $event_photos ) ) :

                    foreach( $event_photos as $event_photo ) :
                    $event_photo_full = wp_get_attachment_url( $event_photo['image'] ); 
                    $event_photo = wp_get_attachment_image_src( $event_photo['image'], array('376','314'), true ); 
                ?>
                    <div class="col-md-4 col-sm-4 col-xs-12">
                      <div class="be-gallery-item">
                        <img src="<?php echo esc_url( $event_photo[0] ); ?>" alt="gallery image" class="img-responsive">
                        <div class="overlay"></div>
                        <a href="<?php echo esc_url( $event_photo_full ); ?>" data-rel="lightcase:myCollection">
                          <img src="<?php echo esc_url( $gallery_icon ); ?>" alt="gallery icon" class="img-responsive">
                        </a>
                      </div><!-- gallery-item -->
                    </div>
                    <?php endforeach; ?>

      		<?php endif; ?>
          </div><!-- row -->
<?php
	    if( ! empty( $gallery_btn_text ) && ! empty( $gallery_btn_url ) ) :

	    	echo '<a href="'. esc_url( $gallery_btn_url ) .'" class="gallery-button default-button" style="background-color: ' . esc_attr( $gallery_btn_bgc ) . '; color: ' . esc_attr( $gallery_btn_color ) . '">' . esc_html( $gallery_btn_text ) . '</a>';

	    endif; ?>          
        </div><!-- container -->
      <?php if( ! empty( $bg_image ) ) : ?>
      </div>
  	  <?php endif; ?>
    </section><!-- gallery -->
    <!-- Gallery end here -->
	<?php
}