<?php
/**
 * Big Event Contact Us Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
function big_event_contact_us( $cf_title, $cf_shortcode, $info_title, $info_groups, $social_profiles, $be_class ) { ?>
<!-- contact start here -->
<section class="contact padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>">
  <div class="container">
    <div class="row">
      <div class="col-md-8 col-sm-12 col-xs-12">
        <div class="contact-form">

          <?php
          if( ! empty( $cf_title ) ) :

          	echo '<h3>' . esc_html( $cf_title ) . '</h3>';

          endif; ?>

		  <?php
		  if( ! empty( $cf_shortcode ) ) :

		  	echo do_shortcode( $cf_shortcode );

		  endif; ?>
        </div>
      </div>
      <div class="col-md-4 col-sm-12 col-xs-12">
        <div class="contact-info">

          <?php
          if( ! empty( $info_title ) ) :

          	echo '<h3>' . esc_html( $info_title ) . '</h3>';

          endif; ?>
          
          <?php
          if( $info_groups ) : ?>
          <ul class="info">

          	<?php
          	foreach( $info_groups as $info_group ) :

          	$info_image 	= isset( $info_group['image'] ) ? $info_group['image'] : '';
          	$info_icon 		= isset( $info_group['info_icon'] ) ? $info_group['info_icon'] : '';
          	$info_content 	= isset( $info_group['description'] ) ? $info_group['description'] : '';
            $image_alt = get_post_meta( $info_image, '_wp_attachment_image_alt', true);
          	$info_image		= wp_get_attachment_url( $info_image );            
          	?>

            <li>

			 <?php
			 if( $info_image ) :

			 	echo '<img class="icon" src="' . esc_url( $info_image ) . '" alt="'.esc_attr($image_alt).'">';

			 else :

			 	echo '<div class="' . esc_attr( $info_icon ) . '"></div>';

			 endif; ?>
              
			
			  <?php
			  if( ! empty( $info_content ) ) :

			  	echo '<div class="content"><p>' . esc_html( $info_content ) . '</p></div>';

			  endif; ?>
            </li>

        	<?php endforeach; ?>

          </ul>
          <?php
          endif; ?>

		  <?php
		  if( $social_profiles ) : ?>
          <ul class="event-social">

          	<?php foreach( $social_profiles as $social_profile ) :

          		echo '<li><a href="' . esc_url( $social_profile['url'] ) . '"><i class="' . esc_attr( $social_profile['info_icon'] ) . '" aria-hidden="true"></i></a></li>';
            
        	endforeach; ?>
          </ul>
          <?php
          endif; ?>
        </div><!-- contact-info -->
      </div>
    </div><!-- row -->
  </div><!-- container -->
</section><!-- contact -->
<!-- contact end here -->
<?php }