<?php
/**
 * Event Hub Shortcodes
 *
 * Visual Composer of Contact Us
 *
 * @package big-event
 * @author CodexCoder
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_contact_us extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'cf_title'			=> '',
			'cf_shortcode'		=> '',
			'info_title'		=> '',
			'info_groups'		=> '',
			'social_profiles'	=> '',
			'be_class'			=> ''
		), $atts ) );
		$info_groups 		= ( array ) vc_param_group_parse_atts( $info_groups );
		$social_profiles 	= ( array ) vc_param_group_parse_atts( $social_profiles );
		ob_start();
			big_event_contact_us( $cf_title, $cf_shortcode, $info_title, $info_groups, $social_profiles, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'			=> esc_html__( 'Contact Us', 'big-event' ),
	'base'			=> 'big_event_contact_us',
	'class'			=> '',
	'category'		=> esc_html__( 'Big Event', 'big-event' ),
	'params'		=> array(
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Contact Form Title', 'big-event' ),
			'param_name'	=> 'cf_title',
			'group'			=> esc_html__( 'Contact Us', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Contact Form Shortcode', 'big-event' ),
			'param_name'	=> 'cf_shortcode',
			'group'			=> esc_html__( 'Contact Us', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Info Title', 'big-event' ),
			'param_name'	=> 'info_title',
			'group'			=> esc_html__( 'Contact Info', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Contact Info', 'big-event' ),
			'param_name'	=> 'info_groups',
			'group'			=> esc_html__( 'Contact Info', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'attach_image',
					'heading'		=> esc_html__( 'Info Image', 'big-event' ),
					'param_name'	=> 'image'
				),
				array(
					'type'			=> 'iconpicker',
					'heading'		=> esc_html__( 'Info Icon', 'big-event' ),
					'param_name'	=> 'info_icon',
					'settings'		=> array(
						'type'			=> 'fontawesome',
						'iconsPerPage'	=> 100
					)
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Info Description', 'big-event' ),
					'param_name'	=> 'description'
				)
			)
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Social Profile', 'big-event' ),
			'param_name'	=> 'social_profiles',
			'group'			=> esc_html__( 'Social', 'big-event' ),
			'params'		=> array(
				array(
					'type'			=> 'iconpicker',
					'heading'		=> esc_html__( 'Social Icon', 'big-event' ),
					'param_name'	=> 'info_icon',
					'settings'		=> array(
						'type'			=> 'fontawesome',
						'iconsPerPage'	=> 100
					)
				),
				array(
					'type'			=> 'textfield',
					'heading'		=> esc_html__( 'Social URL', 'big-event' ),
					'param_name'	=> 'url'
				)
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;