<?php
/**
 * Big Event Testimonial Shortcode
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
if( function_exists( 'vc_map' ) ) :
class WPBakeryShortcode_big_event_contact_info extends WPBakeryShortcode {
	protected function content( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'bgimage'		=> '',
			'title'			=> '',
			'sub_title'		=> '',
			'infos'         => '',
			'be_class'		=> ''
		), $atts ) );
		$infos 	= ( array ) vc_param_group_parse_atts( $infos );
		ob_start();
			big_event_contact_info( $bgimage, $title, $sub_title, $infos, $be_class );
		return ob_get_clean();
	}
}

vc_map( array(
	'name'		=> esc_html__( 'Contact Info', 'big-event' ),
	'base'		=> 'big_event_contact_info',
	'class'		=> '',
	'category'	=> esc_html__( 'Big Event', 'big-event' ),
	'params'	=> array(
        array(
            'type'			=> 'attach_image',
            'heading'		=> esc_html__( 'Background Image', 'big-event' ),
            'param_name'	=> 'bgimage',
            'group'			=> esc_html__( 'General', 'big-event' )
        ),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Title', 'big-event' ),
			'param_name'	=> 'title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Subtitle', 'big-event' ),
			'param_name'	=> 'sub_title',
			'group'			=> esc_html__( 'General', 'big-event' )
		),
		array(
			'type'			=> 'param_group',
			'heading'		=> esc_html__( 'Info', 'big-event' ),
			'param_name'	=> 'infos',
			'group'			=> esc_html__( 'Info', 'big-event' ),
			'params'		=> array(
				array(
                    'type' => 'iconpicker',
                    'heading' => esc_html__( 'Title Icon', 'big-event'),
                    'param_name' => 'icon',
                    'settings' => array(
                      'emptyIcon' => false, // default true, display an "EMPTY" icon?
                      'type' => 'fontawesome',
                      'iconsPerPage' => 100, // default 100, how many icons per/page to display
                    ),
                    'description' => esc_html__( 'Select icon from library.', 'big-event' ),
                ),
                array(
                    'type'			=> 'textfield',
                    'heading'		=> esc_html__( 'Text', 'big-event' ),
                    'param_name'	=> 'text',
                ),                                
			)
		),
		array(
			'type'			=> 'textfield',
			'heading'		=> esc_html__( 'Extra Class Name', 'big-event' ),
			'param_name'	=> 'be_class',
			'group'			=> esc_html__( 'Extra Class', 'big-event' ),
			'description'	=> esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'big-event' )
		)
	)
) );
endif;

function big_event_contact_info( $bgimage, $title, $sub_title, $infos, $be_class ) {
    $bgimage_src = wp_get_attachment_image_src($bgimage, 'full');
    $css_classes = array(
        'contact-section'
    );
    if(!empty($be_class)):
        $css_classes[] = $be_class;
    endif;
        
    $section_attribute = array();
    $section_attribute[] = 'class="' . implode( ' ', $css_classes ) . '"';
    if(!empty($bgimage)):
        $section_attribute[] = 'style="background-image: url('.esc_attr($bgimage_src[0]).')"';
    endif;
	?>
    <!-- Gallery start here -->
    <section <?php echo implode( ' ', $section_attribute ) ?>>           
        <div class="section-wrapper">
          <div class="col-md-6 col-sm-12">
            <div class="row">
              <div class="contact-banner">
              </div>
            </div>
          </div>
          <div class="col-md-6 col-sm-12">
            <div class="row">
                <div class="contact-desc section-padding">                                         
                    <div class="section-header">
                        <?php
                        if( ! empty( $title ) ) :
                          echo '<h3>' . esc_html( $title ) . '</h3>';
                        endif;

                        if( ! empty( $sub_title ) ) :
                          echo '<span>' . esc_html( $sub_title ) . '</span>';
                        endif; 
                        ?>  
                    </div>
                    <div class="contact-item">
                        <?php if (!empty($infos)): ?>                        
                        <ul class="contact-item-list">
                            <?php foreach ($infos as $info): ?>                           
                            <li>
                                <div class="event-date">
                                    <div class="event-date-inner">
                                        <?php 
                                        if (!empty($info['icon'])):
                                            echo '<i class="'.esc_attr($info['icon']).'" aria-hidden="true"></i>';
                                        endif; 
                                        ?>                                        
                                    </div>
                                </div><!--event-date mail.com end-->
                                <?php 
                                if (!empty($info['text'])):
                                    echo '<span>' . esc_html( $info['text'] ) . '</span>';
                                endif; 
                                ?>                                
                            </li>
                            <?php endforeach; ?>                            
                        </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
          </div> 
        </div><!--section-wrapper end-->         
    </section>    
	<?php
}