<?php
/**
 * Big Event About Us Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_about_us_5( $bg_color, $image, $video_url, $title, $title_color, $subtitle, $subtitle_color, $content, $read_more_btn_text, $read_more_btn_url, $read_more_bg_color,$read_more_color,$buy_ticket_btn_text, $buy_ticket_btn_url, $buy_ticket_bg_color,$buy_ticket_color,$be_class ) { 
    $image = wp_get_attachment_image_src( $image, 'full' );
    $image_alt = get_post_meta( $image, '_wp_attachment_image_alt', true);
    ?>

  <!-- About start here -->
  <section class="dark-layout">
      <div class="dark-overlay-right about about-six padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ) ?>">
        <div class="section-wrapper">
        <div class="container">
            <?php if( ! empty( $image ) ) : ?>
              <div class="about-thumb">
                <img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php echo esc_attr($image_alt) ?>" class="img-responsive">
                <?php if( ! empty( $video_url ) ) : ?>
                <a href="<?php echo esc_url($video_url)?>" class="play" data-rel="lightcase:myCollection"><i class="fa fa-play"></i></a>
                <?php endif; ?>
              </div>
            <?php endif; ?>
          <div class="section-header text-center">
            <?php
            if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

            <div class="section-header text-center">

                <?php
                if( ! empty( $title ) ) :

                    echo '<h2 style="color: ' . esc_attr( $title_color ) . '">' . esc_html( $title ) . '</h2>';

                endif; ?>

                <?php
                if( ! empty( $subtitle ) ) :

                    echo '<p style="color: ' . esc_attr( $subtitle_color ) . '"><em>' . esc_html( $subtitle ) . '</em></p>';

                endif; ?>
                
            </div>

            <?php endif; ?>        
          </div>
            <?php
                if( ! empty( $content ) ) :
                    echo '<p class="content">' . wp_kses_post( $content ) . '</p>';
                endif; 
            ?>
            <ul class="about-button">
                <?php
                if( ! empty( $read_more_btn_text ) ) :

                    echo '<li><a style="background-color: ' . esc_attr( $read_more_bg_color ) . ';color: ' . esc_attr( $read_more_color ) . '" href="' . esc_url( $read_more_btn_url ) . '" class="default-button">' . esc_html( $read_more_btn_text ) . '</a></li>';

                endif; ?>

                <?php
                if( ! empty( $buy_ticket_btn_text ) ) :

                    echo '<li><a style="background-color: ' . esc_attr( $buy_ticket_bg_color ) . ';color: ' . esc_attr( $buy_ticket_color ) . '" href="' . esc_url( $buy_ticket_btn_url ) . '" class="default-button">' . esc_html( $buy_ticket_btn_text ) . '</a></li>';

                endif; ?>
            </ul>
        
        </div><!-- container -->
        </div>
      </div>
  </section>
  <!-- About end here -->
<?php }