<?php
/**
 * Big Event About Us Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_about_us_4( $bg_color, $title, $title_color, $subtitle, $subtitle_color, $content, $read_more_btn_text, $read_more_btn_url, $read_more_btn_color, $buy_ticket_btn_text, $buy_ticket_btn_url, $buy_ticket_btn_color, $event_title, $event_time, $time_offset, $be_class ) {
    
    $section_classes = array(
        'about',
        'about-seven',
        'padding-120'
    );
    if(!empty($be_class)):
        $section_classes[] = $be_class;
    endif;
    $section_class = implode( ' ', $section_classes );
    $section_attribute = array();
    $section_attribute[] = 'class="' . esc_attr( $section_class ) . '"';
    if(!empty($bg_color)):
        $section_attribute[] = 'style="background-color: '.esc_attr($bg_color).'"';
    endif;
    ?>
<!-- About start here -->
<section <?php echo implode( ' ', $section_attribute ) ?>>
  <div class="container">
    <div class="row">
      <div class="col-md-6 col-sm-12 col-xs-12">
  
    <?php if( ! empty( $title ) || ! empty( $subtitle ) ) : ?>

    <div class="section-header">

        <?php
        if( ! empty( $title ) ) :
            echo '<h2 style="color: ' . esc_attr( $title_color ) . '">' . esc_html( $title ) . '</h2>';
        endif;

        if( ! empty( $subtitle ) ) :
            echo '<p style="color: ' . esc_attr( $subtitle_color ) . '"><em>' . esc_html( $subtitle ) . '</em></p>';
        endif; 
        ?>
        
    </div>

    <?php endif; ?>

    <?php
    if( ! empty( $content ) ) :

      echo '<p>' . wp_kses_post( $content ) . '</p>';

    endif; ?>

      <ul class="about-button">
          <?php
          if( ! empty( $read_more_btn_text ) && ! empty( $read_more_btn_url ) ) :

              echo '<li><a style="background-color: ' . esc_attr( $read_more_btn_color ) . '" href="' . esc_url( $read_more_btn_url ) . '" class="default-button">' . esc_html( $read_more_btn_text ) . '</a></li>';

          endif; ?>

          <?php
          if( ! empty( $buy_ticket_btn_text ) && ! empty( $buy_ticket_btn_url ) ) :

              echo '<li><a style="background-color: ' . esc_attr( $buy_ticket_btn_color ) . '" href="' . esc_url( $buy_ticket_btn_url ) . '" class="default-button">' . esc_html( $buy_ticket_btn_text ) . '</a></li>';

          endif; ?>
      </ul>
      </div>
      <div class="col-md-6 col-sm-12 col-xs-12">
        <?php
        if( ! empty( $event_title ) ) :

          echo '<h2 class="one-page-about" style="color: ' . esc_attr( $title_color ) . '">' . esc_html( $event_title ) . '</h2>';

        endif; ?>
        <ul id="about-countdown" class="about-countdown countdown" data-coundown="<?php echo esc_attr( $event_time ); ?>" data-day="<?php esc_html_e('Day','big-event'); ?>" data-days="<?php esc_html_e('Days','big-event'); ?>" data-hour="<?php esc_html_e('Hour','big-event'); ?>" data-hours="<?php esc_html_e('Hours','big-event'); ?>" data-minute="<?php esc_html_e('Minute','big-event'); ?>" data-minutes="<?php esc_html_e('Minutes','big-event'); ?>" data-second="<?php esc_html_e('Second','big-event'); ?>" data-seconds="<?php esc_html_e('Seconds','big-event'); ?>" data-timeoffset="<?php echo esc_attr($time_offset) ?>">          
            <li class="clock-item"><span class="count-number days"><?php esc_html_e('00','big-event') ?></span>
                <p class="days_text count-text"><?php esc_html_e('Days','big-event'); ?></p>
            </li>

            <li class="clock-item"><span class="count-number hours"><?php esc_html_e('00','big-event') ?></span>
                <p class="hours_text count-text"><?php esc_html_e('Hours','big-event'); ?></p>
            </li>

            <li class="clock-item"><span class="count-number minutes"><?php esc_html_e('00','big-event') ?></span>
                <p class="minutes_text count-text"><?php esc_html_e('Minutes','big-event'); ?></p>
            </li>

            <li class="clock-item"><span class="count-number seconds"><?php esc_html_e('00','big-event') ?></span>
                <p class="seconds_text count-text"><?php esc_html_e('Seconds','big-event'); ?></p>
            </li>
        </ul>
      </div>
    </div><!-- row -->
  
  </div><!-- container -->
</section>
<!-- About end here -->
<?php }