<?php
/**
 * Big Event About Us Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_about_us_3( $bg_color, $images, $title, $title_color, $subtitle, $subtitle_color, $content, $content_color, $content_extra_class, $read_more_btn_text, $read_more_btn_url, $read_more_btn_color, $read_more_btn_hover_color, $buy_ticket_btn_text, $buy_ticket_btn_url, $buy_ticket_btn_color, $buy_ticket_btn_hover_color, $be_class ) {
    ?>
<!-- About start here -->
<section class="about about-three padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>">
  <div class="container">
    <div class="row">

      <?php
      if( ! empty( $images ) ) : ?>

      <div class="col-md-6 col-sm-12 col-xs-12">
        <div class="image">

          <?php
          $i = 1;
          foreach( $images as $image ) :
          $single_img = wp_get_attachment_image_src( $image['image'], 'full' );
          
          if( $i == 1 ) : ?>
          
            <div class="left">
              <img src="<?php echo esc_url( $single_img[0] ); ?>" alt="about iamge" class="img-responsive">
            </div>
          
          <?php endif; ?>

          <?php
          $i++;
          endforeach; ?>

          <?php
          $i = 1;
          foreach( $images as $image ) :
          $single_img = wp_get_attachment_image_src( $image['image'], 'full' );
          
          if( $i > 1 ) : ?>
          
            <div class="right">
              <?php if( $i == 2 ) : ?>
                <div class="top">
                  <img src="<?php echo esc_url( $single_img[0] ); ?>" alt="about iamge" class="img-responsive">
                </div>
              <?php endif; ?>
              <?php if( $i == 3 ) : ?>
                <div class="bottom">
                  <img src="<?php echo esc_url( $single_img[0] ); ?>" alt="about iamge" class="img-responsive">
                </div>
              <?php endif; ?>
            </div>
          
          <?php endif; ?>

          <?php
          $i++;
          endforeach; ?>

          



        </div>
      </div>

      <?php endif; ?>
      <div class="col-md-6 col-sm-12 col-xs-12">
        <div class="content">
          <div class="section-header">
            <?php
            if( ! empty( $title ) ) :

                echo '<h2 style="color: ' . esc_attr( $title_color ) . '">' . esc_html( $title ) . '</h2>';

            endif; ?>

            <?php
            if( ! empty( $subtitle ) ) :

                echo '<p style="color: ' . esc_attr( $subtitle_color ) . '"><em>' . esc_html( $subtitle ) . '</em></p>';

            endif; ?>
          </div>
            <?php
            if( ! empty( $content ) ) :
                echo '<p style="color: ' . esc_attr( $content_color ) . '">' . wp_kses_post( $content ) . '</p>';
            endif; ?>
            <ul class="about-button">
                <?php
                if( ! empty( $read_more_btn_text ) && ! empty( $read_more_btn_url ) ) :

                    echo '<li><a style="background-color: ' . esc_attr( $read_more_btn_color ) . '" href="' . esc_url( $read_more_btn_url ) . '" class="default-button">' . esc_html( $read_more_btn_text ) . '</a></li>';

                endif; ?>

                <?php
                if( ! empty( $buy_ticket_btn_text ) && ! empty( $buy_ticket_btn_url ) ) :

                    echo '<li><a style="background-color: ' . esc_attr( $buy_ticket_btn_color ) . '" href="' . esc_url( $buy_ticket_btn_url ) . '" class="default-button">' . esc_html( $buy_ticket_btn_text ) . '</a></li>';

                endif; ?>
            </ul>
        </div>
      </div>
    </div>
  </div><!-- container -->
</section>
<!-- About end here -->
<?php }