<?php
/**
 * Big Event About Us Shortcode
 *
 * @link https://codex.wordpress.org/Shortcode_API
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

function big_event_about_us_1( $bg_color, $title, $title_color, $subtitle, $subtitle_color, $content, $read_more_btn_text, $read_more_btn_url, $read_more_btn_color, $buy_ticket_btn_text, $buy_ticket_btn_url, $buy_ticket_btn_color, $be_class ) { ?>
<!-- About start here -->
<section class="about about-six padding-120<?php echo ( $be_class ) ? ' ' . esc_attr( $be_class ) : ''; ?>" style="background-color: <?php echo esc_attr( $bg_color ); ?>">
  <div class="container">
  
    <?php
    if( ! empty( $title ) || ! empty( $sub_title ) ) : ?>

    <div class="section-header text-center">

    	<?php
    	if( ! empty( $title ) ) :

    		echo '<h2 style="color: ' . esc_attr( $title_color ) . '">' . esc_html( $title ) . '</h2>';

    	endif; ?>

    	<?php
    	if( ! empty( $subtitle ) ) :

    		echo '<p style="color: ' . esc_attr( $subtitle_color ) . '"><em>' . esc_html( $subtitle ) . '</em></p>';

    	endif; ?>
        
    </div>

    <?php endif; ?>

    <?php
	if( ! empty( $content ) ) :
		echo '<p>' . wp_kses_post( $content ) . '</p>';
	endif; ?>
    <ul class="about-button">
    	<?php
    	if( ! empty( $read_more_btn_text ) && ! empty( $read_more_btn_url ) ) :

    		echo '<li><a style="background-color: ' . esc_attr( $read_more_btn_color ) . '" href="' . esc_url( $read_more_btn_url ) . '" class="default-button">' . esc_html( $read_more_btn_text ) . '</a></li>';

    	endif; ?>

    	<?php
    	if( ! empty( $buy_ticket_btn_text ) && ! empty( $buy_ticket_btn_url ) ) :

    		echo '<li><a style="background-color: ' . esc_attr( $buy_ticket_btn_color ) . '" href="' . esc_url( $buy_ticket_btn_url ) . '" class="default-button">' . esc_html( $buy_ticket_btn_text ) . '</a></li>';

    	endif; ?>
    </ul>
  
  </div><!-- container -->
</section>
<!-- About end here -->
<?php }