<?php
/**
 * Big Event functions and definitions
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

if( class_exists( 'wooCommerce' ) ) :
/**
 * Remove woocommerce_output_content_wrapper
 */

function big_event_remove_woocommerce_output_content_wrapper() {
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
}

add_action( 'init', 'big_event_remove_woocommerce_output_content_wrapper' );

/**
 * Remove woocommerce_output_content_wrapper_end
 */
function big_event_remove_woocommerce_output_content_wrapper_end() {
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
}
add_action( 'init', 'big_event_remove_woocommerce_output_content_wrapper_end' );


/**
 * Remove woocommerce_breadcrumb
 */
function big_event_remove_woocommerce_breadcrumb() {
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
}
add_action( 'init', 'big_event_remove_woocommerce_breadcrumb' );

/**
 * Remove woocommerce_catalog_ordering
 */
function big_event_remove_woocommerce_catalog_ordering() {
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
}
add_action( 'init', 'big_event_remove_woocommerce_catalog_ordering' );

/**
 * Remove woocommerce_template_loop_product_link_open
 */
function big_event_remove_woocommerce_template_loop_product_link_open() {
	remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
}
add_action( 'init', 'big_event_remove_woocommerce_template_loop_product_link_open' );

/**
 * Remove woocommerce_template_loop_product_link_open
 */
function big_event_remove_woocommerce_template_loop_product_link_close() {
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
}
add_action( 'init', 'big_event_remove_woocommerce_template_loop_product_link_close' );

/**
 * Remove woocommerce_template_loop_product_link_open
 */
function big_event_remove_woocommerce_show_product_loop_sale_flash() {
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
}
add_action( 'init', 'big_event_remove_woocommerce_show_product_loop_sale_flash' );


/**
 * Modify woocommerce_template_loop_product_title
 */
if ( ! function_exists( 'woocommerce_template_loop_product_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function woocommerce_template_loop_product_title() {
		echo '<h4><a href="' . get_permalink() . '">' . get_the_title() . '</a></h4>';
	}
}

/**
 * Remove woocommerce_template_loop_product_link_open
 */
function big_event_remove_woocommerce_template_loop_rating() {
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
}
add_action( 'init', 'big_event_remove_woocommerce_template_loop_rating' );

/**
 * Remove woocommerce_template_loop_product_link_open
 */
function big_event_remove_woocommerce_template_loop_price() {
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
}
add_action( 'init', 'big_event_remove_woocommerce_template_loop_price' );

/**
 * Add woocommerce_template_loop_product_link_open
 */
function big_event_add_woocommerce_template_loop_rating() {
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 10 );
}
add_action( 'init', 'big_event_add_woocommerce_template_loop_rating' );

/**
 * Add woocommerce_template_loop_product_link_open
 */
function big_event_add_woocommerce_template_loop_price() {
	add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 5 );
}
add_action( 'init', 'big_event_add_woocommerce_template_loop_price' );


/**
 * Remove woocommerce_output_content_wrapper
 */

function big_event_remove_woocommerce_show_product_sale_flash() {
	remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
}
add_action( 'init', 'big_event_remove_woocommerce_show_product_sale_flash' );

/**
 * WooCommerce Extra Support
 */

function big_event_woocommerce_extra_support() {
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
}

add_action( 'init', 'big_event_woocommerce_extra_support' );

/**
 * Remove woocommerce_output_content_wrapper
 */

function big_event_remove_woocommerce_output_related_products() {
	remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
}
add_action( 'init', 'big_event_remove_woocommerce_output_related_products' );

/**
 * WooCommerce mini cart dropdown
 */

function big_event_wc_cart_dropdown() { ?>
    <span>
        <i class="fa fa-shopping-bag"></i>
            <span class="item-counter"><?php echo WC()->cart->cart_contents_count; ?></span>
    </span>
    <div class="header-mini-cart woocommerce">  
    <?php 
    echo wc_get_template( 'cart/mini-cart.php' );
    ?>
    </div>
    <?php
}
/**
 * WooCommerce update mini cart on ajax click
 */
add_filter( 'woocommerce_add_to_cart_fragments', function($fragments) {

    ob_start();
    ?>

    <div class="header-mini-cart woocommerce">
        <?php woocommerce_mini_cart(); ?>
    </div>

    <?php $fragments['div.header-mini-cart'] = ob_get_clean();

    return $fragments;

} );

// Ensure cart contents update when products are added to the cart via AJAX
add_filter( 'woocommerce_add_to_cart_fragments', 'big_event_woocommerce_header_add_to_cart_fragment' );
function big_event_woocommerce_header_add_to_cart_fragment($fragments){
    ob_start();
    ?>
    <span class="item-counter">
        <?php echo WC()->cart->get_cart_contents_count(); ?>
    </span>
    <?php

    $fragments['span.item-counter'] = ob_get_clean();

    return $fragments;
}

/**
 *  shop product per page
 */
add_filter( 'loop_shop_per_page', 'big_event_loop_shop_per_page', 20 );

function big_event_loop_shop_per_page( $cols ) {
  // $cols contains the current number of products per page based on the value stored on Options -> Reading
  // Return the number of products you wanna show per page.
  $cols = 9;
  return $cols;
}


// Remove cross-sells at cart

remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );

// Handle cart in header fragment for ajax add to cart
add_filter( 'woocommerce_add_to_cart_fragments', 'big_event_header_add_to_cart_fragment' );

if ( !function_exists( 'big_event_header_add_to_cart_fragment' ) ) {

    function big_event_header_add_to_cart_fragment( $fragments ) {
        ob_start();
        ?>

        <ul class="dropdown-menu first_dropdown shop_feature">
            <?php
            if( sizeof( WC()->cart->get_cart() ) > 0 ) :

            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) :
                $_product = $cart_item['data'];
                // Only display if allowed
                if ( ! apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) || ! $_product->exists() || $cart_item['quantity'] == 0 ) continue;
                // Get price
                $product_price     = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
            ?>
            <li class="feature_item">
                <div class="featured_image">
                    <?php echo $_product->get_image(); ?>
                </div>
                <div class="featured_content">
                    <h3>
                        <a href="<?php echo get_permalink( $cart_item['product_id'] ); ?>"><?php echo apply_filters('woocommerce_widget_cart_product_title', $_product->get_title(), $_product ); ?>
                        </a>
                    </h3>
                    <span class="remove">
                        <a href="<?php echo esc_url(WC()->cart->get_remove_url($cart_item_key)); ?>"><i class="fa fa-times"></i></a>
                    </span>
                    <p class="quantity">
                        <?php _e( 'Quantity: ', 'big-event' ); ?>
                        <?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', $cart_item['quantity'], $cart_item, $cart_item_key ); ?>
                    </p>
                    <span><?php echo apply_filters( 'woocommerce_widget_cart_item_price', $product_price, $cart_item, $cart_item_key ); ?></span>
                </div>
            </li>
            <?php endforeach; ?>
            <?php if ( sizeof( WC()->cart->get_cart() ) > 0 ) : ?>
                <li class="cart_total"><?php _e( 'total order:', 'big-event' ); ?> <span><?php echo WC()->cart->get_cart_subtotal(); ?></span></li>
                <li><a href="<?php echo esc_url( WC()->cart->get_checkout_url() ); ?>" class="check_out"><?php _e( 'check out', 'big-event' ); ?></a></li>
            <?php endif; ?>
            <?php else : ?>
                <li class="empty">
                    <?php echo esc_html__( 'No products in the cart.', 'big-event' ); ?>
                </li>
            <?php endif; ?>
        </ul>

        <?php
        $fragments['.dropdown-menu first_dropdown shop_feature'] = ob_get_clean();

        return $fragments;
    }

}

endif;


