<?php
//numeric pagination
function big_event_numeric_pagination() {

	if( is_singular() )
		return;

	global $wp_query;

	/** Stop execution if there's only 1 page */
	if( $wp_query->max_num_pages <= 1 )
		return;

	$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
	$max   = intval( $wp_query->max_num_pages );

	/**	Add current page to the array */
	if ( $paged >= 1 )
		$links[] = $paged;

	/**	Add the pages around the current page to the array */
	if ( $paged >= 3 ) {
		$links[] = $paged - 1;
		$links[] = $paged - 2;
	}

	if ( ( $paged + 2 ) <= $max ) {
		$links[] = $paged + 2;
		$links[] = $paged + 1;
	}

	echo '<div class="pagination-area"><ul class="pagination">' . "\n";

	/**	Previous Post Link */
	if ( get_previous_posts_link() )
		printf( '<li class="previous">%s</li>' . "\n", get_previous_posts_link('<< Previous') );

	/**	Link to first page, plus ellipses if necessary */
	if ( ! in_array( 1, $links ) ) {
		$class = 1 == $paged ? ' class="active"' : '';

		printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );

		if ( ! in_array( 2, $links ) )
			echo '<li>&#8226;&#8226;&#8226;</li>';
	}

	/**	Link to current page, plus 2 pages in either direction if necessary */
	sort( $links );
	foreach ( (array) $links as $link ) {
		$class = $paged == $link ? ' class="active"' : '';
		printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
	}

	/**	Link to last page, plus ellipses if necessary */
	if ( ! in_array( $max, $links ) ) {
		if ( ! in_array( $max - 1, $links ) )
			echo '<li>&#8226;&#8226;&#8226;</li>' . "\n";

		$class = $paged == $max ? ' class="active"' : '';
		printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $max ) ), $max );
	}

	/**	Next Post Link */
	if ( get_next_posts_link() )
		printf( '<li class="next">%s</li>' . "\n", get_next_posts_link('Next >>') );

	echo '</ul></div>' . "\n";

}
if ( ! function_exists( 'big_event_getcat' ) ) {
    function big_event_getcat(){
            $categories_obj = get_categories();
            $cats = array();
            $cats['All'] = '0';
            foreach ($categories_obj as $cat) {
                $cats[$cat->cat_name] = $cat->term_id;
            }
            return $cats;
    }
}
if ( ! function_exists( 'big_event_get_terms_vc' ) ) {
    function big_event_get_terms_vc($texonomy){
        global $wpdb;
        $query = 'SELECT DISTINCT 
                        t.name,t.term_id,t.slug 
                    FROM
                      '.$wpdb->prefix.'terms t 
                    INNER JOIN 
                      '.$wpdb->prefix.'term_taxonomy tax 
                    ON 
                      tax.term_id = t.term_id
                    WHERE 
                        ( tax.taxonomy = \'' . $texonomy . '\')';                     
        $categories_obj =  $wpdb->get_results($query , ARRAY_A);
        $cats = array();
        $cats['All'] = '0';
        foreach ($categories_obj as $cat) {
            $cats[$cat['name']] = $cat['term_id'];
        }
        return $cats;
    }
}

/**
 * Add multiple select dropdown field to vc_map
 */
if( function_exists( 'vc_map' ) ) :
    function big_event_dropdown_multi_settings_field( $param, $value ) {
       $param_line = '';
       $param_line .= '<select multiple name="'. esc_attr( $param['param_name'] ).'" class="wpb_vc_param_value wpb-input wpb-select '. esc_attr( $param['param_name'] ).' '. esc_attr($param['type']).'">';
       foreach ( $param['value'] as $text_val => $val ) {
           if ( is_numeric($text_val) && (is_string($val) || is_numeric($val)) ) {
                        $text_val = $val;
                    }
                    $selected = '';

                    if(!is_array($value)) {
                        $param_value_arr = explode(',',$value);
                    } else {
                        $param_value_arr = $value;
                    }

                    if ($value!=='' && in_array($val, $param_value_arr)) {
                        $selected = ' selected="selected"';
                    }
                    $param_line .= '<option class="'.$val.'" value="'.$val.'"'.$selected.'>'.$text_val.'</option>';
                }
       $param_line .= '</select>';

       return  $param_line;
    }	
    vc_add_shortcode_param( 'dropdown_multi', 'big_event_dropdown_multi_settings_field' );
endif;

if ( ! function_exists( 'big_event_get_custom_terms_vc' ) ) {
    function big_event_get_custom_terms_vc($texonomy){
        global $wpdb;
        $query = 'SELECT DISTINCT 
                        t.name,t.term_id,t.slug 
                    FROM
                      '.$wpdb->prefix.'terms t 
                    INNER JOIN 
                      '.$wpdb->prefix.'term_taxonomy tax 
                    ON 
                      tax.term_id = t.term_id
                    WHERE 
                        ( tax.taxonomy = \'' . $texonomy . '\')';                     
        $categories_obj =  $wpdb->get_results($query , ARRAY_A);
        $cats = array();
        $cats['All'] = '0';
        foreach ($categories_obj as $cat) {
            $cats[$cat['name']] = $cat['term_id'];
        }
        return $cats;
    }
}

/* Convert hexdec color string to rgb(a) string */
if ( ! function_exists( 'big_event_hex2rgba' ) ) {
    function big_event_hex2rgba($color, $opacity = false) {

        $default = 'rgb(51,102,255)';

        //Return default if no color provided
        if(empty($color))
              return $default; 

        //Sanitize $color if "#" is provided 
            if ($color[0] == '#' ) {
                $color = substr( $color, 1 );
            }

            //Check if color has 6 or 3 characters and get values
            if (strlen($color) == 6) {
                    $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
            } elseif ( strlen( $color ) == 3 ) {
                    $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
            } else {
                    return $default;
            }

            //Convert hexadec to rgb
            $rgb =  array_map('hexdec', $hex);

            //Check if opacity is set(rgba or rgb)
            if($opacity){
                if(abs($opacity) > 1)
                    $opacity = 1.0;
                $output = 'rgba('.implode(",",$rgb).','.$opacity.')';
            } else {
                $output = 'rgb('.implode(",",$rgb).')';
            }

            //Return rgb(a) color string
            return $output;
    }
}

function big_event_menu_notitle( $menu ){
  return $menu = preg_replace('/ title=\"(.*?)\"/', '', $menu );

}
add_filter( 'wp_nav_menu', 'big_event_menu_notitle' );
add_filter( 'wp_page_menu', 'big_event_menu_notitle' );
add_filter( 'wp_list_categories', 'big_event_menu_notitle' );


