<?php
/**
 * Template for comments and pingbacks.
 *
 * Used as a callback by wp_list_comments() for displaying the comments.
 *
 * @link http://codex.wordpress.org/Function_Reference/wp_list_comments
 * @package big-event
 * @since 1.0.0
 * @version 1.0.0
 * @author CodexCoder
 */

function big_event_comment_template( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;
    switch ( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' :
            // Display trackbacks differently than normal comments.
            ?>
            <li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
            <p><?php esc_html__( 'Pingback:', 'big-event' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( esc_html__( '(Edit)', 'big-event' ), '<span class="edit-link">', '</span>' ); ?></p>
            <?php
            break;
        default :
            // Proceed with normal comments.
            global $post;
            ?>
        <li <?php comment_class( 'comment-item' ); ?> id="li-comment-<?php comment_ID(); ?>">
                <div class="image">
                    <?php echo get_avatar( $comment, 80 ); ?>
                </div><!-- /.profile-image -->

                <div class="com-content">
                    <h4><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) ?>"><?php echo get_comment_author_link(); ?></a></h4>
                    <span>
                        <time datetime="<?php echo get_comment_time( 'c' ); ?>">
                            <?php echo sprintf( esc_html__( '%1$s at %2$s', 'big-event' ), get_comment_date(), get_comment_time() ) ?>
                        </time>
                    </span>

                    <div class="content">
                        <?php if ( '0' == $comment->comment_approved ) : ?>
                            <p class="comment-awaiting-moderation"><?php esc_html__( 'Your comment is awaiting moderation.', 'big-event' ); ?></p>
                        <?php endif; ?>

                        <?php comment_text(); ?>
                        <?php edit_comment_link( esc_html__( 'Edit', 'big-event' ), '<p class="edit-link">', '</p>' ); ?>
                    </div><!-- /.content -->

                    <?php
                    	comment_reply_link(
                    		array_merge( $args,
                    			array(
                    				'reply_text' => esc_html__( 'Reply', 'big-event' ),
                    				'depth' 	 => $depth,
                    				'max_depth'  => $args['max_depth']
                    				)
                    			)
                    		);
                    ?>
                </div><!-- /.contents -->
            <?php
            break;
    endswitch; // end comment_type check
}


/**
 * Comment Form
 *
 * @since 1.0.0
 * @version 1.0.0
 * @author CodexCoder
 */
function big_event_comment_form() {
    $commenter = wp_get_current_commenter();
    $req = get_option( 'comment_author_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $fields = array(
        'author' => '<div class="row"><div class="col-md-4 col-sm-4 col-xs-12"><input id="author" class="comment-input" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" placeholder="' . esc_attr__( 'Name', 'big-event' ) . '"' . $aria_req . ' /></div>',
        'email'  => '<div class="col-md-4 col-sm-4 col-xs-12"><input id="email" class="comment-input" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" placeholder="' . esc_attr__( 'Email', 'big-event' ) . '"' . $aria_req . ' /></div>',
        'url'    => '<div class="col-md-4 col-sm-4 col-xs-12"><input id="url" class="comment-input" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" placeholder="' . esc_attr__( 'Website', 'big-event' ) . '"/></div></div>',
    );
    $comments_args = array(
        'fields' => $fields,
        'title_reply'=> esc_html__( 'Leave a Reply', 'big-event' ),
        'title_reply_before'    => '<h4>',
        'title_reply_after'     => '</h4>',
        'label_submit'  => esc_html__( 'Submit Comment', 'big-event' ),
        'class_submit'  => 'comment-submit',
        'comment_notes_before'  => '',
        'comment_field' => '<textarea id="comment" class="comment-input" name="comment" cols="45" rows="5" placeholder="' . esc_attr__( 'Comment', 'big-event' ) . '" aria-required="true"></textarea>',
        'comment_notes_after' => '',
    );
    comment_form( $comments_args );
}