<?php
/**
 * Custom functions that act independently of the theme templates
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function big_event_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

    if ( is_admin_bar_showing() ) {
        $classes[] = 'show-admin-bar';
    }    
    if( function_exists( 'cs_get_option' ) ) :
        $be_is_box_layout = '';
        if( is_page() ) :
            $be_custom_page_options 	= get_post_meta( get_the_ID(), '_be_custom_page_options', true );
            $be_custom_page_settings	= isset( $be_custom_page_options['be_custom_page_settings'] ) ? $be_custom_page_options['be_custom_page_settings'] : '';
        endif;
        if( is_page() && $be_custom_page_settings == true ) :
            $be_is_box_layout			= isset( $be_custom_page_options['be_is_box_layout'] ) ? $be_custom_page_options['be_is_box_layout'] : '';
            $be_background_image		= isset( $be_custom_page_options['be_background_image'] ) ? $be_custom_page_options['be_background_image'] : '';
            $be_header_style            = isset( $be_custom_page_options['be_header_style'] ) ? $be_custom_page_options['be_header_style'] : cs_get_option( 'be_header_style' );
        else :
            $be_is_box_layout			= cs_get_option( 'be_is_box_layout' );
            $be_background_image		= cs_get_option( 'be_background_image' );
            $be_header_style            = cs_get_option( 'be_header_style' );
        endif;
        
        $classes[] = 'header-'.$be_header_style;
        
        if( $be_is_box_layout == true ) :
            $classes[] = 'boxed';
        endif;
    endif;
	return $classes;
}
add_filter( 'body_class', 'big_event_body_classes' );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function big_event_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'big_event_pingback_header' );

// background image function
if( ! function_exists('big_event_bg_image')) :
    function big_event_bg_image($background_items) {
        if(! empty($background_items)) {
            $color      = ! empty($background_items['color']) ? 'background-color: '. $background_items['color'] .';' : '';
            $image      = ! empty($background_items['image']) ? 'background-image: url('. $background_items['image'] .');' : '';
            $cover      = ! empty($background_items['size']) ? 'background-size: '. $background_items['size'] .';' : '';
            $repeat     = ! empty($background_items['repeat']) ? 'background-repeat: '. $background_items['repeat'] .';' : '';
            $position   = ! empty($background_items['position']) ? 'background-position: '. $background_items['position'] .';' : '';
            $attachment = ! empty($background_items['attachment']) ? 'background-attachment: '. $background_items['attachment'] .';' : '';                
            echo 'style="'. $color . $image . $cover . $repeat . $position . $attachment .'"';
        }
    }
endif;
/**
  * Add post view counter
  */
function big_event_post_views($post_ID) {

    //Set the name of the Posts Custom Field.
    $count_key = 'post_views_count';

    //Returns values of the custom field with the specified key from the specified post.
    $count = get_post_meta($post_ID, $count_key, true);

    //If the the Post Custom Field value is empty.
    if($count == '') {
        $count = 0; // set the counter to zero.

        //Delete all custom fields with the specified key from the specified post.
        delete_post_meta($post_ID, $count_key);

        //Add a custom (meta) field (Name/value)to the specified post.
        add_post_meta($post_ID, $count_key, '0');
        return $count . '';

        //If the the Post Custom Field value is NOT empty.
    } else {
        $count++; //increment the counter by 1.
        //Update the value of an existing meta key (custom field) for the specified post.
        update_post_meta($post_ID, $count_key, $count);

        //If statement, is just to have the singular form 'View' for the value '1'
        if($count == '1'){
            return $count . '';
        }
        //In all other cases return (count) Views
        else {
            return $count . '';
        }
    }
}
add_action( 'init', 'big_event_post_views' );



/**
 * Moving the comments text field to bottom
 */
function big_event_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields[ 'comment' ];
    unset( $fields[ 'comment' ] );
    $fields[ 'comment' ] = $comment_field;
    return $fields;
}

add_filter( 'comment_form_fields', 'big_event_move_comment_field_to_bottom' );


/**
 * Heal Pro excerpt more modify
 */
function big_event_new_excerpt_more( $more ) {
    return '';
}
add_filter('excerpt_more', 'big_event_new_excerpt_more');


/**
 * Big Event Social Share
 */
function big_event_social_share( $post_id ){ ?>
    <ul class="share event-social">
        <?php $pinterest_img = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'full' ); ?>
        <li><span><?php _e( 'Share Post :', 'big-event' ); ?></span></li>
        <li><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink( $post_id ) ); ?>"><i class="fa fa-facebook"></i></a></li>
        <li><a target="_blank" href="https://twitter.com/home?status=<?php the_title() ?> <?php echo urlencode( get_permalink( $post_id ) ); ?>"><i class="fa fa-twitter"></i></a></li>
        <li><a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode( get_permalink( $post_id ) ); ?>&title=<?php the_title(); ?>"><i class="fa fa-linkedin"></i></a></li>
        <li><a target="_blank" href="https://plus.google.com/share?url=<?php echo urlencode( get_permalink( $post_id ) ); ?>"><i class="fa fa-google-plus"></i></a></li>
        <li><a target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode( get_permalink() ); ?>&media=<?php echo esc_url( $pinterest_img[0] ); ?>&description=<?php the_title(); ?>"><i class="fa fa-camera"></i></a></li>
    </ul>
<?php }

/*     Remove query var     */
if ( ! function_exists( 'big_event_remove_css_js_ver' ) ) :
    function big_event_remove_css_js_ver( $src ) {
        if( strpos( $src, '?ver=' ) )
        $src = remove_query_arg( 'ver', $src );
        return $src;
    }
    add_filter( 'style_loader_src', 'big_event_remove_css_js_ver', 10, 2 );
    add_filter( 'script_loader_src', 'big_event_remove_css_js_ver', 10, 2 );
endif;

/*Import content data*/
if ( ! function_exists( 'big_event_import_files' ) ) :
function big_event_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Default Demo', 'big-event' ),
            'import_file_url'            => 'http://codexcoder.com/demo/big-event/content.xml',
            'import_widget_file_url'     => 'http://codexcoder.com/demo/big-event/widgets.wie',
            'import_customizer_file_url' => 'http://codexcoder.com/demo/big-event/customizer.dat',
            'import_preview_image_url'   => 'http://codexcoder.com/demo/big-event/preview-theme.png',
            'preview_url'                => 'http://demos.codexcoder.com/big-event/',
        ),
        array(
            'import_file_name'             => esc_html__( 'Revolution Sliders', 'big-event' ),
            'import_preview_image_url'   => 'http://codexcoder.com/demo/big-event/preview-revslider.png',
            'preview_url'                => 'http://demos.codexcoder.com/big-event/',
        ),
        array(
            'import_file_name'           => esc_html__( 'Theater', 'big-event' ),
            'import_file_url'            => 'http://codexcoder.com/demo/big-event/theater/content.xml',
            'import_preview_image_url'   => 'http://codexcoder.com/demo/big-event/theater/preview-theater.jpg',
            'preview_url'                => 'http://demos.codexcoder.com/theater/',
        ),
        array(
            'import_file_name'           => esc_html__( 'Event Management', 'big-event' ),
            'import_file_url'            => 'http://codexcoder.com/demo/big-event/event-management/content.xml',
            'import_widget_file_url'     => 'http://codexcoder.com/demo/big-event/event-management/widgets.wie',
            'import_preview_image_url'   => 'http://codexcoder.com/demo/big-event/event-management/event-management-preview.jpg',
            'preview_url'                => 'http://demos.codexcoder.com/event-management/',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'big_event_import_files' );
endif;


 //Assign Menu after import
if ( ! function_exists( 'big_event_after_import' ) ) :
function big_event_after_import( $selected_import ) { 
    if ( 'Default Demo' === $selected_import['import_file_name'] ) :
        //Set Menu
        $primary        = get_term_by( 'name', 'Primary', 'nav_menu' );
        $one_page    = get_term_by( 'name', 'One Page', 'nav_menu' );
        $mobile_menu    = get_term_by( 'name', 'Mobile Menu', 'nav_menu' );
        set_theme_mod( 'nav_menu_locations' , array( 
                'primary' => $primary->term_id, 
                'one-page' => $one_page->term_id,
                'mobile-menu' => $mobile_menu->term_id 
            ) 
        );

       //Set Front page
       $page = get_page_by_title( 'Home Music Festival');
       if ( isset( $page->ID ) ):
        update_option( 'page_on_front', $page->ID );
        update_option( 'show_on_front', 'page' );
       endif;
       
        //import codestar framework demo data
        $file = get_template_directory().'/inc/plugins/cs-options/default-options.txt';
        if ( function_exists( 'cs_get_option' ) && file_exists( $file ) ):
            $data = file_get_contents( $file );
            $decoded_data = cs_decode_string ( $data );
            update_option( '_cs_options', $decoded_data );
        endif;                
    endif;
    if ( 'Revolution Sliders' === $selected_import['import_file_name'] ) :
        //Import Revolution Slider
        if ( class_exists( 'RevSlider' ) ):
            $slider_array = array(
                'http://codexcoder.com/demo/big-event/revslider/full-screen-event.zip',
                'http://codexcoder.com/demo/big-event/revslider/blur-effect-slider.zip',
                'http://codexcoder.com/demo/big-event/revslider/music-festival-right-info.zip',
                'http://codexcoder.com/demo/big-event/revslider/event-slider-right-info-dark.zip',     
                'http://codexcoder.com/demo/big-event/revslider/creative-music.zip',       
                'http://codexcoder.com/demo/big-event/revslider/independence-day.zip'          
            );

            $slider = new RevSlider();                        

            foreach($slider_array as $filepath):
                $tmp = download_url($filepath);
                $slider->importSliderFromPost(true,true,$tmp);  
            endforeach;       
        endif;
    endif;
    if ( 'Theater' === $selected_import['import_file_name'] ) :
        //Set Menu
        $primary        = get_term_by( 'name', 'Main Menu', 'nav_menu' );
        $mobile_menu    = get_term_by( 'name', 'Main Menu', 'nav_menu' );
        set_theme_mod( 'nav_menu_locations' , array( 
                'primary' => $primary->term_id, 
                'mobile-menu' => $mobile_menu->term_id 
            ) 
        );

       //Set Front page
       $page = get_page_by_title( 'Homepage');
       if ( isset( $page->ID ) ):
        update_option( 'page_on_front', $page->ID );
        update_option( 'show_on_front', 'page' );
       endif;
       
        //import codestar framework demo data
        $file = get_template_directory().'/inc/plugins/cs-options/theater-options.txt';
        if ( function_exists( 'cs_get_option' ) && file_exists( $file ) ):
            $data = file_get_contents( $file );
            $decoded_data = cs_decode_string ( $data );
            update_option( '_cs_options', $decoded_data );
        endif; 
        
        //Import Revolution Slider
        if ( class_exists( 'RevSlider' ) ) :
            $slider_array = array(
                'http://codexcoder.com/demo/big-event/theater/theater.zip'        
            );

            $slider = new RevSlider();                        

            foreach($slider_array as $filepath):
                $tmp = download_url($filepath);
                $slider->importSliderFromPost(true,true,$tmp);  
            endforeach;      
        endif;
    endif;

    if ( 'Event Management' === $selected_import['import_file_name'] ) :
        //Set Menu
        $primary        = get_term_by( 'name', 'Main Menu', 'nav_menu' );
        $mobile_menu    = get_term_by( 'name', 'Main Menu', 'nav_menu' );
        set_theme_mod( 'nav_menu_locations' , array( 
                'primary' => $primary->term_id, 
                'mobile-menu' => $mobile_menu->term_id 
            ) 
        );

       //Set Front page
       $page = get_page_by_title( 'Event Management Homepage');
       if ( isset( $page->ID ) ):
        update_option( 'page_on_front', $page->ID );
        update_option( 'show_on_front', 'page' );
       endif;
       
        //import codestar framework demo data
        $file = get_template_directory().'/inc/plugins/cs-options/event-management-options.txt';
        if ( function_exists( 'cs_get_option' ) && file_exists( $file ) ):
            $data = file_get_contents( $file );
            $decoded_data = cs_decode_string ( $data );
            update_option( '_cs_options', $decoded_data );
        endif; 
                
    endif;
}
add_action( 'pt-ocdi/after_import', 'big_event_after_import' );
endif;