<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */
$be_custom_page_settings = '';
$be_is_page_header		 = '';
$be_is_banner			 = '';
$be_banner_style		 = '';
$be_is_menu_cart         = '';
$be_is_buy_button        = '';
$be_buy_button_text      = '';
$be_buy_button_url       = '';
$be_is_box_layout        = '';
$body_attributes         = '';
$be_header_style         = '';
if( function_exists( 'cs_get_option' ) ) :
    $be_is_menu_cart            = cs_get_option( 'be_is_menu_cart' );
    $be_is_buy_button           = cs_get_option( 'be_is_buy_button' );
    $be_buy_button_text         = cs_get_option( 'be_buy_button_text' );
    $be_buy_button_url          = cs_get_option( 'be_buy_button_url' );

    
	if( is_page() ) :
		$page_options 	= get_post_meta( get_the_ID(), '_be_custom_page_options', true );
		$be_custom_page_settings	= isset( $page_options['be_custom_page_settings'] ) ? $page_options['be_custom_page_settings'] : '';
		$be_is_banner				= isset( $page_options['be_is_banner'] ) ? $page_options['be_is_banner'] : '';
		$be_banner_style			= isset( $page_options['be_banner_style'] ) ? $page_options['be_banner_style'] : '';
	endif;

	if( is_page() && $be_custom_page_settings == true ) :
		$be_is_page_header			= isset( $page_options['be_is_page_header'] ) ? $page_options['be_is_page_header'] : '';
		$be_is_box_layout			= isset( $page_options['be_is_box_layout'] ) ? $page_options['be_is_box_layout'] : '';
		$be_background_image		= isset( $page_options['be_background_image'] ) ? $page_options['be_background_image'] : '';
		$be_header_style            = isset( $page_options['be_header_style'] ) ? $page_options['be_header_style'] : cs_get_option( 'be_header_style' );
	else :
		$be_is_page_header			= cs_get_option( 'be_is_page_header' );
		$be_is_box_layout			= cs_get_option( 'be_is_box_layout' );
		$be_background_image		= cs_get_option( 'be_background_image' );
        $be_header_style            = cs_get_option( 'be_header_style' );
	endif;
    if (is_singular('event')):
        $event_options = get_post_meta( get_the_ID(), '_be_event_options', true );
        $be_is_page_header          = isset( $event_options['be_is_page_header'] ) ? $event_options['be_is_page_header'] : '';
    endif;
    
    $body_attributes = array();
    if (( $be_header_style == 2)){
        $body_attributes[] = 'id="scroll-top"';
        $body_attributes[] = 'data-spy="scroll"';
        $body_attributes[] = 'data-target="onepage-nav-menu"';
    }
endif;

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php echo implode( ' ', $body_attributes ) ?> <?php if ($be_is_box_layout == '1' && !empty($be_background_image)): big_event_bg_image($be_background_image);endif; ?>>
    <div class="body-wrapper">
    <div class="mobile-menu-area">
        <div class="close">
            <i class="fa fa-close"></i>
        </div>
    	<div class="mobile-menu">
    		<?php 
            if( $be_header_style == 2 && has_nav_menu( 'one-page' )) :
                wp_nav_menu( array(
                    'menu_id'        => 'onepage-nav-menu',
                    'menu_class'        => 'onepage m-menu',
                    'container'         => false,
                    'theme_location'    => 'one-page',
                    'depth'             => 0,
                ) );  
            elseif( has_nav_menu( 'mobile-menu' ) ) :         
                wp_nav_menu( array(
                    'menu_class'        => 'm-menu',
                    'container'         => false,
                    'theme_location'    => 'mobile-menu'
                ) );
            else :
                wp_nav_menu( array(
                    'menu_class'        => 'm-menu',
                    'container'         => false,
                    'theme_location'    => 'primary',
                ) );
            endif; 
    		?>    		
    	</div>
        <?php
        if( $be_is_menu_cart == TRUE || $be_is_buy_button == TRUE ) : ?>
            <div class="ms-btn-group">

              <?php
              global $woocommerce;
              if( class_exists( 'WooCommerce' ) && $be_is_menu_cart == TRUE ) : ?>

                <a href="<?php echo wc_get_page_permalink( 'cart' ); ?>" class="ms-btn"><?php esc_html_e('View Cart','big-event') ?></a>

              <?php 
              endif;

              if( $be_is_buy_button == TRUE && ! empty( $be_buy_button_text ) && ! empty( $be_buy_button_url ) ) :

                echo '<a href="' . esc_url( $be_buy_button_url ) . '" class="ms-btn">' . esc_html( $be_buy_button_text ) . '</a>';

              endif; ?>

            </div>
        <?php endif; ?>        
    </div>
    <?php	

    if( !empty($be_header_style) ) :

    	get_template_part( 'template-parts/headers/header', $be_header_style );

    else :

    	get_template_part( 'template-parts/headers/header', '1' );

    endif; 

    get_template_part( 'template-parts/page', 'header' );    

    
    if( $be_is_banner == true ) :
    	get_template_part( 'template-parts/banners/banner', $be_banner_style );    
    endif;