<?php
/**
 * Big Event functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

define( 'BIGEVENT_ASSETS', get_template_directory_uri() . '/assets' );

/**
 * Load Init File
 */

require get_template_directory() . '/inc/init.php';


// change custom post type default value
if( function_exists( 'cs_get_option' ) ) :
    function big_event_register_post_type_args( $args, $post_type ) {
        $be_event_post_slug = cs_get_option( 'be_event_post_slug' );
        $be_speakers_post_slug = cs_get_option( 'be_speakers_post_slug' );
        if ( 'event' === $post_type && !empty($be_event_post_slug) ) {
            $args['rewrite']['slug'] = $be_event_post_slug;
        }
        if ( 'speakers' === $post_type && !empty($be_speakers_post_slug) ) {
            $args['rewrite']['slug'] = $be_speakers_post_slug;
        }
        return $args;
    }
    add_filter( 'register_post_type_args', 'big_event_register_post_type_args', 10, 2 );
    
    //change slugs used for archive pages
    function big_event_change_event_taxonomies_slug( $args, $taxonomy ) {
       $be_event_post_slug = cs_get_option( 'be_event_post_slug' );
       $be_speakers_post_slug = cs_get_option( 'be_speakers_post_slug' );
       if ( 'event_categories' === $taxonomy ) {
          $args['rewrite']['slug'] = $be_event_post_slug.'-category';
       }
       if ( 'speakers_category' === $taxonomy ) {
          $args['rewrite']['slug'] = $be_speakers_post_slug.'-category';
       }
       return $args;
    }
    add_filter( 'register_taxonomy_args', 'big_event_change_event_taxonomies_slug', 10, 2 );
    
    
    $be_event_post_name = cs_get_option( 'be_event_post_name' );
    if(!empty($be_event_post_name)):
        function big_event_change_event_labels() {
            $post_name = cs_get_option( 'be_event_post_name' );
            $event_object = get_post_type_object( 'event' );
            $event_object->labels->name = $post_name;
        }
        add_action( 'wp_loaded', 'big_event_change_event_labels', 20 );
    endif;
    
    $be_speaker_post_name = cs_get_option( 'be_speaker_post_name' );
    if(!empty($be_speaker_post_name)):
        function big_event_change_speaker_labels() {
            $post_name = cs_get_option( 'be_speaker_post_name' );
            $event_object = get_post_type_object( 'speakers' );
            $event_object->labels->name = $post_name;
        }
        add_action( 'wp_loaded', 'big_event_change_speaker_labels', 20 );        
    endif;
        
endif;