<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

$be_is_footer_newsletter    = '';
$be_is_footer               = '';
$be_footer_style            = '';
$be_footer_bg               = '';
$be_footer_overlay          = '';
$be_footer_social_profiles  = '';
$be_copyright_section       = '';
if( function_exists( 'cs_get_option' ) ) :
    $be_custom_page_options     = get_post_meta( get_the_ID(), '_be_custom_page_options', true );
    $be_custom_footer_settings    = isset( $be_custom_page_options['be_custom_footer_settings'] ) ? $be_custom_page_options['be_custom_footer_settings'] : '';
    if( is_page() && $be_custom_footer_settings == true ):
        $be_is_footer     = isset( $be_custom_page_options['be_is_footer'] ) ? $be_custom_page_options['be_is_footer'] : '';
        $be_footer_style  = isset( $be_custom_page_options['be_footer_style'] ) ? $be_custom_page_options['be_footer_style'] : '';
        else:
        $be_is_footer     = cs_get_option( 'be_is_footer' );
        $be_footer_style  = cs_get_option( 'be_footer_style' );
    endif;
    $be_is_footer_newsletter    = cs_get_option( 'be_is_footer_newsletter' );
endif;

?>

<?php
if( $be_is_footer_newsletter == true && is_active_sidebar( 'mailpoet' ) ) : ?>
<!-- Newsletter Start here -->
<div id="contact" class="newsletter newsletter-six">
  <div class="container">
    <?php dynamic_sidebar( 'mailpoet' ); ?>    
  </div><!-- container -->
</div>
<!-- Newsletter End here -->
<?php 
endif; 

if($be_is_footer == 1):
    get_template_part( 'template-parts/footers/footer', $be_footer_style );
else:
    get_template_part( 'template-parts/footers/footer', 1 );
endif;
?>
</div><!-- end body wrapper -->
<?php wp_footer(); ?>

</body>
</html>
