<?php 
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// TAXONOMY OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options     = array();

// -----------------------------------------
// Taxonomy Options                        -
// -----------------------------------------
$options[]   = array(
  'id'       => '_event_categories_options',
  'taxonomy' => 'event_categories', // category, post_tag or your custom taxonomy name
  'fields'   => array(
        array(
            'id'      => 'ctitle',
            'type'    => 'text',
            'title'   => 'Category Title','big-event',
            'desc'    => 'The title will appears on "Events Tab" shortcode','big-event',
        ),
        array(
            'id'      => 'csubtitle',
            'type'    => 'text',
            'title'   => 'Category Subtitle','big-event',
            'desc'    => 'The subtitle will appears on "Events Tab" Shortcode','big-event',
        ),
        array(
            'id'      => 'csdesc',
            'type'    => 'textarea',
            'title'   => 'Category Sort Description','big-event',
            'desc'    => 'The description will appears on "Events Tab" Shortcode','big-event',
        ),
        array(
            'id'    => 'cicon',
            'type'  => 'image',
            'title' => 'Category Icon',
            'desc'    => 'The icon will appears on "Events Tab" Shortcode','big-event',
        ),
        array(
            'id'      => 'btntext',
            'type'    => 'text',
            'default' => 'See All Event',
            'title'   => 'Button Text','big-event',
            'desc'    => 'The subtitle will appears on "Events Tab" Shortcode','big-event',
        ),
        array(
            'id'            => 'btncolor',
            'type'          => 'color_picker',
            'default'       => '#005aff;',
            'title'         => esc_html__( 'Button Background Color', 'big-event' ),
        ),
        array(
            'id'      => 'btnurl',
            'type'    => 'text',
            'default' => '#',
            'title'   => 'Button Custom URL','big-event',
            'desc'    => 'If you want to use default archive template, keep this field blank.','big-event',
        ),
  ),
);

CSFramework_Taxonomy::instance( $options );