<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options      = array();

// -----------------------------------------
// Page Metabox Options                    -
// -----------------------------------------
$options[]    = array(
    'id'        => '_be_custom_page_options',
    'title'     => esc_html__( 'Big Event Page Options', 'big-event' ),
    'post_type' => 'page',
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(
        array(
            'name'      => 'be_page_metabox',
            'fields'    => array(
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Custom Page Settings', 'big-event' ),
                ),
                array(
                    'id'        => 'be_custom_page_settings',
                    'type'      => 'switcher',
                    'title'     => esc_html__( 'Custom Page Settings', 'big-event' ),
                    'label'     => esc_html__( 'If you want custom settings for this page please switch "on" to this button', 'big-event' ),
                    'default'   => false
                ),
                array(
                    'id'            => 'be_is_box_layout',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Box Layout', 'big-event' ),
                    'default'       => false,
                    'dependency'    => array( 'be_custom_page_settings', '==', 'true' )
                ),
                array(
                    'id'    => 'be_background_image',
                    'type'  => 'background',
                    'title' =>  esc_html__('Background Field','event-term'),
                    'default' => array(
                        'repeat'     => 'no-repeat',
                        'position'   => 'center center',
                        'attachment' => 'fixed',
                        'size' => 'cover',
                        'color'      => '#fff',
                    ),
                    'dependency' => array( 'be_custom_page_settings|be_is_box_layout', '==|==', 'true|true' ), 
                ),
                array(
                    'id'            => 'be_menu_background_color',
                    'type'          => 'color_picker',
                    'default'       => '#ee0034',
                    'title'         => esc_html__( 'Theme Primary Color', 'big-event' ),
                    'dependency'    => array( 'be_custom_page_settings', '==', 'true' )
                ),
                array(
                    'id'            => 'be_secondary_color',
                    'type'          => 'color_picker',
                    'default'       => '#ffea00',
                    'title'         => esc_html__( 'Theme Secondary Color', 'big-event' ),
                    'dependency'    => array( 'be_custom_page_settings', '==', 'true' )
                ),
                array(
                    'id' => 'be_header_style',
                    'type' => 'radio',
                    'title' => esc_html__('Header Style', 'big-event'),
                    'class' => 'horizontal',
                    'options' => array(
                        '' => esc_html__('Default Header', 'big-event'),
                        '1' => esc_html__('Header 1', 'big-event'),
                        '2' => esc_html__('Header 2 (One Page Nav)', 'big-event'),
                        '3' => esc_html__('Header 3', 'big-event'),
                    ),
                    'default' => '',
                    'attributes' => array(
                        'data-depend-id' => 'be_header_style',
                    ),
                    'dependency'    => array( 'be_custom_page_settings', '==', 'true' )
                ),
                array(
                    'id'            => 'be_transparent_menu',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Transparent Menu', 'big-event' ),
                    'label'         => esc_html__( 'If you want to enable transparent menu, switch "on" to this button', 'big-event' ),
                    'default'       => true,
                    'dependency'   => array( 'be_header_style', 'any', '1,2' )
                ),
                array(
                    'id'            => 'be_transparent_menu_bg',
                    'type'          => 'color_picker',
                    'title'         => esc_html__( 'Transparent Menu Background Color', 'big-event' ),
                    'dependency'   => array( 'be_header_style', 'any', '1,2' )
                ),  
                array(
                    'id'            => 'be_site_logo',
                    'type'          => 'image',
                    'title'         => esc_html__( 'Site Logo', 'big-event' ),
                    'add_title'     => esc_html__( 'Add Logo', 'big-event' ),
                    'dependency'    => array( 'be_custom_page_settings', '==', 'true' )
                ),
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Header Counter and Breadcrumb', 'big-event' ),
                ),
                array(
                    'id'        => 'be_custom_header_counter',
                    'type'      => 'switcher',
                    'title'     => esc_html__( 'Custom Header Counter and Breadcrumb Settings', 'big-event' ),
                    'label'     => esc_html__( 'If you want custom settings for this page please switch "on" to this button', 'big-event' ),
                    'default'   => false
                ),                
                array(
                    'id'            => 'be_is_page_header',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Header Counter and Breadcrumb?', 'big-event' ),
                    'label'         => esc_html__( 'If you want to disable page header for all pages, switch "off" to this button', 'big-event' ),
                    'default'       => false,
                    'dependency'    => array( 'be_custom_header_counter', '==', 'true' )
                ),
                array(
                    'id'            => 'be_is_page_coundown',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Page Coundown', 'big-event' ),
                    'label'         => esc_html__( 'Do you want to display page coundown?', 'big-event' ),
                    'default'       => false,
                    'dependency'    => array( 'be_custom_header_counter', '==', 'true' )
                ),
                array(
                    'id'            => 'be_coundown_date',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Date', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: 24', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_month',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Month', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: December', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_year',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Year', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: 2017', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_subtitle',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Subtitle', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_title',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Title', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_time',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Date Time', 'big-event' ),
                    'desc'          => esc_html__( 'Date Time Format: mm/dd/yyyy 17:00:00', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )                    
                ),
                array(
                    'id'            => 'be_time_offset',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Time GMT UTC offset', 'big-event' ),
                    'desc'          => esc_html__( 'ex: -5', 'big-event' ),
                    'default'       => '-5',
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_booking_text',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Booking Now Button Text', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_booking_url',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Booking Now Button URL', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_page_header_bg',
                    'type'          => 'upload',
                    'title'         => esc_html__( 'Page Header Background', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_header', '==|==', 'true|true' )
                ),
                                
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Banner', 'big-event' )
                ),
                array(
                    'id'            => 'be_is_banner',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Page Banner', 'big-event' ),
                    'label'         => esc_html__( 'If you want to display a banner for this page switch "on" to this button
', 'big-event' ),
                    'default'       => false
                ),
                array(
                    'id'            => 'be_banner_style',
                    'type'          => 'radio',
                    'title'         => esc_html__( 'Banner Style', 'big-event' ),
                    'class'         => 'horizontal',
                    'options'       => array(
                        '1'         => esc_html__( 'Banner 1', 'big-event' ),
                        '2'         => esc_html__( 'Banner 2', 'big-event' ),
                        '3'         => esc_html__( 'Banner 3', 'big-event' ),
                        '4'         => esc_html__( 'Banner 4', 'big-event' ),
                        '5'         => esc_html__( 'Banner 5', 'big-event' ),
                        '6'         => esc_html__( 'Banner 6', 'big-event' ),
                        '7'         => esc_html__( 'Banner 7', 'big-event' ),
                        '8'         => esc_html__( 'Banner 8', 'big-event' ),
                        '9'         => esc_html__( 'Banner 9 (Custom Slider)', 'big-event' ),
                        '10'        => esc_html__( 'Banner 10 (Slider Plugin)', 'big-event' ),
                        '11'        => esc_html__( 'Banner 11 (Dark)', 'big-event' ),
                        '12'        => esc_html__( 'Banner 12', 'big-event' ),
                        '13'        => esc_html__( 'Banner 13', 'big-event' ),
                        '14'        => esc_html__( 'Banner 14 (Search)', 'big-event' ),
                    ),
                    'dependency'    => array( 'be_is_banner', '==', 'true' ),
                    'default'       => '1'
                ),
                array(
                    'id'                => 'be_banner_slider_content',
                    'type'              => 'group',                    
                    'title'             => esc_html__( 'Banner Slider Content', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Content', 'big-event' ),
                    'accordion_title'   => esc_html__( 'Content', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'image',
                            'type'      => 'image',
                            'title'     => esc_html__( 'Title 1', 'big-event' )
                        ),
                        array(
                            'id'        => 'title1',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title 1', 'big-event' )
                        ),
                        array(
                            'id'        => 'title2',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title 2', 'big-event' )
                        ),
                        array(
                            'id'        => 'title3',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title 3', 'big-event' )
                        ),
                        
                    ),
                    'dependency'    => array( 'be_is_banner|be_banner_style_9', '==|==', 'true|true' ),
                ),
                array(
                    'id'        => 'be_slider_shortcode',
                    'type'      => 'textarea',
                    'title'     => esc_html__( 'Enter Slider Shortcode', 'big-event' ),
                    'desc'          => esc_html__( 'If you you want to use any free or premium slider plugin please enter shortcode here. This field is applicable only for banner 10', 'big-event' ),
                    'dependency'    => array( 'be_is_banner|be_banner_style_10', '==|==', 'true|true' ),
                ),
                array(
                    'id'            => 'be_is_theme_event',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Custom Event Info', 'big-event' ),
                    'dependency'    => array( 'be_is_banner', '==', 'true' ),
                    'default'       => false,
                    'desc'          => esc_html__( 'If you turn on this switch your theme option event will be disabled. Your event info will display from here for this page', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_image',
                    'type'          => 'upload',
                    'title'         => esc_html__( 'Banner Background Image', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 1, 2, 3, 8 & 14', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_video',
                    'type'          => 'upload',
                    'title'         => esc_html__( 'Banner Background Video (Uploaded)', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 4,5,6,11', 'big-event' ),
                    'settings'      => array(
                        'upload_type'   => 'video',
                        'button_title'  => esc_html__( 'Upload', 'big-event' ),
                        'frame_title'   => esc_html__( 'Select a video', 'big-event' ),
                        'insert_title'  => esc_html__( 'Use this video', 'big-event' )
                    ),
                ),
                array(
                    'id'            => 'be_banner_embeded_video',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Youtube Video ID', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 4,5,6,11. If you want to use Youtube video as background video please enter video id from your youtube video url.', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_slider',
                    'type'          => 'gallery',
                    'title'         => esc_html__( 'Banner Background Slider', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 4, 5, 6, 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_title',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Event Title', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 1, 6, 7, 8, 11, 12, 13 & 14', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_subtitle',
                    'type'          => 'textarea',
                    'title'         => esc_html__( 'Event Subtitle', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 1, 2, 3, 4, 5, 6, 7, 8 11, 12, 13 & 14', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_date',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Event Date', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: 24', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 1, 2, 3, 4, 8 & 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_month',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Event Month', 'big-event' ),
                    'desc'          => esc_html__( 'Event Month ex: December', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 1, 2, 3, 4, 6, 7, 8 & 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_year',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Event Year', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 1, 2, 3, 4, 5, 6, 7, 8 & 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_date_duration',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Event Duration Date', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 2, 3, 4, 6, 7, 8 & 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_location',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Event Location', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 2, 3, 4, 6, 7, 8 & 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_register_text',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Registration Heading', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 7', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_registration_shortcode',
                    'type'          => 'textarea',
                    'title'         => esc_html__( 'Registration Shortcode', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 7', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_coundown_time',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Date Time', 'big-event' ),
                    'desc'          => esc_html__( 'To display event counter properly it is must needed to enter event date time in this format- mm/dd/yyyy 17:00:00( For Banner 1, 2, 3, 4, 6 & 11 )', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_banner_time_offset',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Time GMT UTC offset ( For Banner 1, 2, 3, 4, 6 & 11 )', 'big-event' ),
                    'default'       => '-5',
                    'desc'          => esc_html__( 'ex: -5', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' )
                ),
                
                array(
                    'id'            => 'be_banner_speaker',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Banner Speaker', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_tickets',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Banner Tickets', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_setas',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Banner Seats', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 11', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_booking_now_text',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Booking Now Button Text', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 3, 4 & 8', 'big-event' )
                ),
                array(
                    'id'            => 'be_banner_booking_now_url',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Booking Now Button URL', 'big-event' ),
                    'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
                    'desc'          => esc_html__( 'For Banner 3, 4 & 8', 'big-event' )
                ),
                
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Footer', 'big-event' ),
                ),
                array(
                    'id'        => 'be_custom_footer_settings',
                    'type'      => 'switcher',
                    'title'     => esc_html__( 'Custom Footer Settings', 'big-event' ),
                    'label'     => esc_html__( 'If you want custom settings for this page footer, please switch "on" to this button', 'big-event' ),
                    'default'   => false
                ),
                array(
                    'id'            => 'be_is_footer',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Footer', 'big-event' ),
                    'label'         => esc_html__( 'Do you want to display footer?', 'big-event' ),
                    'default'       => true,
                    'dependency'    => array( 'be_custom_footer_settings', '==', 'true' )
                ),
                array(
                    'id' => 'be_footer_style',
                    'type' => 'radio',
                    'title' => esc_html__('Footer Style', 'big-event'),
                    'class' => 'horizontal',
                    'options' => array(
                        '1' => esc_html__('Footer 1', 'big-event'),
                        '2' => esc_html__('Footer 2', 'big-event'),
                    ),
                    'default' => '1',
                    'attributes' => array(
                        'data-depend-id' => 'be_footer_style',
                    ),
                    'dependency'    => array( 'be_custom_footer_settings', '==', 'true' )
                ),
                array(
                    'id'            => 'be_footer_logo',
                    'type'          => 'upload',
                    'title'         => esc_html__( 'Footer Logo', 'big-event' ),
                    'settings'      => array(
                        'upload_type'   => 'image',
                        'button_title'  => 'Upload',
                        'frame_title'   => esc_html__('Select an image','big-event' ),
                        'insert_title'  => esc_html__('Use this image','big-event' ),
                    ),
                    'dependency'    => array( 'be_custom_footer_settings', '==', 'true' )
                ),
                array(
                    'id'            => 'be_footer_bg',
                    'type'          => 'upload',
                    'title'         => esc_html__( 'Footer Background', 'big-event' ),
                    'settings'      => array(
                        'upload_type'   => 'image',
                        'button_title'  => 'Upload',
                        'frame_title'   => esc_html__('Select an image','big-event' ),
                        'insert_title'  => esc_html__('Use this image','big-event' ),
                    ),
                    'dependency'    => array( 'be_custom_footer_settings', '==', 'true' )
                ),
            ),
        ),
    ),
);


/**
 * Speaker Custom Post Type Options
 */

$options[]  = array(
    'id'        => '_be_speakers_post_options',
    'title'     => esc_html__( 'Speakers Post Options', 'big-event' ),
    'post_type' => 'speakers',
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(
        array(
            'name'      => 'be_speakers_basic_info',
            'fields'    => array(
                array(
                    'id'    => 'be_speakers_icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Icon', 'big-event' )
                ),
                array(
                    'id'    => 'be_speakers_designation',
                    'type'  => 'text',
                    'title' => esc_html__( 'Designation', 'big-event' )
                ),
                array(
                    'id'                => 'be_speakers_social_info',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Speaker Social Profile', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Profile', 'big-event' ),
                    'accordion_title'   => esc_html__( 'Add New Field', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'be_speakers_social_info_icon',
                            'type'      => 'icon',
                            'title'     => esc_html__( 'Social Icon', 'big-event' )
                        ),
                        array(
                            'id'        => 'be_speakers_social_info_url',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Social URL', 'big-event' )
                        )
                    )
                ),
                array(
                    'type'      => 'heading',
                    'content'   => esc_html__( 'For Speaker Details Page', 'big-event' )
                ),
                array(
                    'id'                => 'be_speakers_contact_info',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Speaker Contact Info', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Info', 'big-event' ),
                    'accordion_title'   => esc_html__( 'Add New Field', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'be_speakers_contact_info_icon',
                            'type'      => 'icon',
                            'title'     => esc_html__( 'Contact Icon', 'big-event' )
                        ),
                        array(
                            'id'        => 'be_speakers_contact_info_text',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Contact Text', 'big-event' )
                        )
                    )
                ),
                array(
                    'type'      => 'subheading',
                    'content'   => esc_html__( 'Personal Statement', 'big-event' )
                ),
                array(
                    'id'        => 'be_speakers_personal_statement_text',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Statement Title', 'big-event' )
                ),
                array(
                    'id'        => 'be_speakers_personal_statement_desc',
                    'type'      => 'wysiwyg',
                    'title'     => esc_html__( 'Statement Description', 'big-event' )
                ),
                array(
                    'type'      => 'subheading',
                    'content'   => esc_html__( 'Personal Skill', 'big-event' )
                ),
                array(
                    'id'        => 'be_speakers_personal_skill_title',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Title', 'big-event' )
                ),
                array(
                    'id'                => 'be_speakers_personal_skills',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Speaker Skills', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Skill', 'big-event' ),
                    'accordion_title'   => esc_html__( 'Add New Field', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Skill', 'big-event' )
                        ),
                        array(
                            'id'        => 'percent',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Skill Level', 'big-event' )
                        )
                    )
                ),
                array(
                    'type'      => 'subheading',
                    'content'   => esc_html__( 'Recognitions Award', 'big-event' )
                ),
                array(
                    'id'        => 'be_speakers_recognition_title',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Title', 'big-event' )
                ),
                array(
                    'id'                => 'be_speakers_recognitions',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Recognition Info', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Info', 'big-event' ),
                    'accordion_title'   => esc_html__( 'Add New Field', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'image',
                            'type'      => 'upload',
                            'title'     => esc_html__( 'Recognition Trophy', 'big-event' )
                        ),
                        array(
                            'id'        => 'award_year',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Wining Year', 'big-event' )
                        )
                    )
                ),
            )
        )
    ),
);


/**
 * Pricing Table Custom Post Type Options
 */

$options[] = array(
    'id'        => '_be_pricing_table_options',
    'title'     => esc_html__( 'Package Options', 'big-event' ),
    'post_type' => 'price-table',
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(
        array(
            'name'      => 'be_packages_info',
            'fields'    => array(
                array(
                    'id'                => 'be_price_sortdesc',
                    'type'              => 'textarea',
                    'title'             => esc_html__( 'Sort Description', 'big-event' )
                ),
                array(
                    'id'                => 'be_price_table_currency',
                    'type'              => 'text',
                    'title'             => esc_html__( 'Package Currency', 'big-event' )
                ),
                array(
                    'id'                => 'be_price_table_rate',
                    'type'              => 'text',
                    'title'             => esc_html__( 'Package Rate', 'big-event' )
                ),
                array(
                    'id'                => 'be_price_table_offers',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Package Offers', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Offer', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Offer', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'offer_title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Offer Title', 'big-event' )
                        ),
                        array(
                            'id'        => 'offer_icon',
                            'type'      => 'icon',
                            'title'     => esc_html__( 'Icon', 'big-event' ),
                            'default'   => 'fa fa-check'
                        )
                    )
                ),
                array(
                    'id'        => 'be_price_table_button_text',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Button Text', 'big-event' ),
                ),
                array(
                    'id'        => 'be_price_table_button_url',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Button URL', 'big-event' )
                ),
            )
        )
    )
);

/**
 * Event Custom Post Type Options
 */

$options[] = array(
    'id'        => '_be_event_options',
    'title'     => esc_html__( 'Event Options', 'big-event' ),
    'post_type' => 'event',
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(
        array(
            'name'      => 'be_event_info',
            'fields'    => array(
                // Event Feed Info
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Event General Info', 'big-event' )
                ),                
                array(
                    'id'        => 'event_banner',
                    'type'      => 'image',
                    'title'     => esc_html__( 'Event Banner', 'big-event' )
                ),
                array(
                    'id'        => 'event_date',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Date', 'big-event' ),
                    'description' => esc_html__( 'Numeric value only. ex: 12', 'big-event' )
                ),
                array(
                    'id'        => 'event_month',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Month Name', 'big-event' ),
                    'description' => esc_html__( 'ex: Jun', 'big-event' )
                ),
                array(
                    'id'        => 'time',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Time', 'big-event' ),
                    'description' => esc_html__( 'ex: 09:30am - 06:30pm', 'big-event' )
                ),
                array(
                    'id'        => 'event_fulldate',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Full Date', 'big-event' ),
                    'description' => esc_html__( 'Numeric value only. ex: 20 January 2018', 'big-event' )
                ),
                array(
                    'id'        => 'location',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Location', 'big-event' )
                ),                
                array(
                    'id'        => 'event_short_desc',
                    'type'      => 'textarea',
                    'title'     => esc_html__( 'Short Description', 'big-event' )
                ),
                array(
                    'id'        => 'event_organizers_name',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Organizer Name', 'big-event' ),
                ),
                array(
                    'id'            => 'event_organizer_image',
                    'type'          => 'image',
                    'title'         => esc_html__( 'Organizer Image', 'big-event' ),
                    'add_title'     => esc_html__( 'Add Image', 'big-event' ),
                    'dependency'     => array( 'event_organizers', '==', 'true' ),
                ),
                array(
                    'id'        => 'organizer_designation',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Organizer Designation', 'big-event' ),
                ),
                array(
                    'id'                => 'event_info',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Event Info', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Info', 'big-event' ),
                    'fields'            => array(
                        array(
                            'id'        => 'title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'description',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Description', 'big-event' )
                        ),                        
                    )
                ),
                array(
                    'id'           => 'ticket_status',
                    'type'         => 'select',
                    'title'        =>  esc_html__('Ticket Status', 'big-event'),
                    'options'      => array(
                        'onsale'        =>  esc_html__('On Sale', 'big-event'),
                        'soldout'       =>  esc_html__('Sold Out', 'big-event'),
                        'cancelled'     =>  esc_html__('Cancelled', 'big-event'),                        
                        'free'          =>  esc_html__('Free', 'big-event'),                        
                    ),
                    'default'   => 'onsale',
                ),
                array(
                    'id'        => 'event_ticket_price',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Ticket Price', 'big-event' )
                ),
                array(
                    'id'        => 'ticket_btntext',
                    'type'      => 'text',
                    'default'   => 'Ticket',
                    'title'     => esc_html__( 'Ticket Button Text', 'big-event' )
                ),
                array(
                    'id'        => 'ticket_url',
                    'type'      => 'text',
                    'default'   => '#',
                    'title'     => esc_html__( 'Ticket URL', 'big-event' )
                ),
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Coundown', 'big-event' )
                ),
                array(
                    'id'            => 'be_coundown_time',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Date Time', 'big-event' ),
                    'desc'          => esc_html__( 'Date Time Format: mm/dd/yyyy 17:00:00', 'big-event' )
                ),
                array(
                    'id'            => 'time_offset',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Time GMT UTC offset', 'big-event' ),
                    'default'       => '-5',
                    'desc'          => esc_html__( 'ex: -5', 'big-event' )
                ),
                
                
                //page header
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Header Counter and Breadcrumb', 'big-event' ),
                ),
                array(
                    'id'        => 'be_custom_header_counter',
                    'type'      => 'switcher',
                    'title'     => esc_html__( 'Custom Header Counter and Breadcrumb Settings', 'big-event' ),
                    'label'     => esc_html__( 'If you want custom settings for this page please switch "on" to this button', 'big-event' ),
                    'default'   => false
                ),                
                array(
                    'id'            => 'be_is_page_header',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Header Counter and Breadcrumb', 'big-event' ),
                    'label'         => esc_html__( 'If you want to disable page header for all pages, switch "off" to this button', 'big-event' ),
                    'default'       => false,
                    'dependency'    => array( 'be_custom_header_counter', '==', 'true' )
                ),
                array(
                    'id'            => 'be_is_page_coundown',
                    'type'          => 'switcher',
                    'title'         => esc_html__( 'Page Coundown', 'big-event' ),
                    'label'         => esc_html__( 'Do you want to display page coundown?', 'big-event' ),
                    'default'       => false,
                    'dependency'    => array( 'be_custom_header_counter', '==', 'true' )
                ),
                array(
                    'id'            => 'be_coundown_date',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Date', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: 24', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_month',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Month', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: December', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_year',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Year', 'big-event' ),
                    'desc'          => esc_html__( 'Ex: 2017', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_subtitle',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Subtitle', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_title',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Coundown Title', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),                
                array(
                    'id'            => 'be_coundown_booking_text',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Booking Now Button Text', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_coundown_booking_url',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Booking Now Button URL', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_coundown', '==|==', 'true|true' )
                ),
                array(
                    'id'            => 'be_page_header_bg',
                    'type'          => 'upload',
                    'title'         => esc_html__( 'Page Header Background', 'big-event' ),
                    'dependency'    => array( 'be_custom_header_counter|be_is_page_header', '==|==', 'true|true' )
                ),
                
                // Event About
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'About', 'big-event' )
                ),
                array(
                    'id'    => 'event_about',
                    'type'  => 'switcher',
                    'title' => 'Event About Tab',         
                    'default' => true,
                ),
                array(
                    'id'        => 'about_tab_title',
                    'type'      => 'text',
                    'default'   => 'About',
                    'title'     => esc_html__( 'Tab Title', 'big-event' ),
                    'dependency'     => array( 'event_about', '==', 'true' ),
                ),
                
                // Event Schedule
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Schedule', 'big-event' )
                ),
                array(
                    'id'    => 'event_schedule',
                    'type'  => 'switcher',
                    'title' => 'Event Schedule Tab',         
                    'default' => false,
                ),
                array(
                    'id'        => 'es_tab_title',
                    'type'      => 'text',
                    'default'   => 'Schedules',
                    'title'     => esc_html__( 'Tab Title', 'big-event' ),
                    'dependency'     => array( 'event_schedule', '==', 'true' ),
                ),
                array(
                    'id'        => 'schedule_time',
                    'type'      => 'text',
                    'default'   => 'Event Time',
                    'title'     => esc_html__( 'Event Time', 'big-event' ),
                    'dependency'     => array( 'event_schedule', '==', 'true' ),
                ),                        
                array(
                    'id'        => 'schedule_session',
                    'type'      => 'text',
                    'default'   => 'Event Session',
                    'title'     => esc_html__( 'Session', 'big-event' ),
                    'dependency'     => array( 'event_schedule', '==', 'true' ),
                ),                        
                array(
                    'id'        => 'schedule_room',
                    'type'      => 'text',
                    'default'   => 'Hall Room',
                    'title'     => esc_html__( 'Room', 'big-event' ),
                    'dependency'     => array( 'event_schedule', '==', 'true' ),
                ),
                array(
                    'id'                => 'event_schedules',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Event Schedule', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Schedule', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Schedule', 'big-event' ),
                    'dependency'     => array( 'event_schedule', '==', 'true' ),
                    'fields'            => array(
                        array(
                            'id'        => 'time',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Time', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'session',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Session', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'room',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Room', 'big-event' )
                        ),                        
                    )
                ),
                
                // Event Speakers
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Speakers', 'big-event' )
                ),
                array(
                    'id'    => 'event_speaker',
                    'type'  => 'switcher',
                    'title' => 'Event Speaker',        
                    'default' => false,
                ), 
                array(
                    'id'        => 'speaker_tab_title',
                    'type'      => 'text',
                    'default'   => 'Speakers',
                    'title'     => esc_html__( 'Speaker Tab Title', 'big-event' ),
                    'dependency' => array( 'event_speaker', '==', 'true' ),
                ),
                array(
                    'id'                => 'event_speakers',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Event Speakers', 'big-event' ),
                    'button_title'      => esc_html__( 'Add Speakers Row', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Speakers Row', 'big-event' ),
                    'dependency'     => array( 'event_speaker', '==', 'true' ),
                    'fields'            => array(
                        array(
                            'id'        => 'title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Row Title', 'big-event' ),                            
                        ),
                        array(
                            'id'      => 'speaker_limit',
                            'type'    => 'number',
                            'title'   =>  esc_html__('Speakers Limit:', 'big-event'),
                            'default'   => '5',
                        ),
                        array(
                            'id'           => 'speaker_from',
                            'type'         => 'radio',
                            'class'        => 'horizontal',
                            'title'        =>  esc_html__('Display Post from?', 'big-event'),
                            'options'      => array(
                                'all'          =>  esc_html__('All', 'big-event'),
                                'category'     =>  esc_html__('Category', 'big-event'),
                                'tag'          =>  esc_html__('Tag', 'big-event'),                        
                            ),
                            'default'   => 'all',
                        ),
                        array(
                            'id'             => 'speaker_cat',
                            'type'           => 'select',
                            'title'          =>  esc_html__('Categories:', 'big-event'),
                            'options'        => 'categories',
                            'query_args'     => array(
                                'type'         => 'speakers',
                                'taxonomy'     => 'speakers_category',
                                'orderby'      => 'post_date',
                                'order'        => 'DESC',
                            ),
                            'attributes' => array(
                                'multiple' => 'multiple',
                                'style'    => 'width: 200px; height: 200px;'
                            ),
                            'default_option' =>  esc_html__('Select Categories', 'big-event'),
                            'default'   => '',
                        ),
                        array(
                            'id'             => 'speaker_tag',
                            'type'           => 'select',
                            'title'          =>  esc_html__('Tags:', 'big-event'),
                            'options'        => 'tags',
                            'query_args'     => array(
                                'taxonomies'   => array( 'post_tag', 'speakers_tag' ),
                                'orderby'      => 'post_date',
                                'order'        => 'DESC',
                            ),
                            'attributes' => array(
                                'multiple' => 'multiple',
                                'style'    => 'width: 200px; height: 200px;'
                            ),
                            'default_option' =>  esc_html__('Select Tags', 'big-event'),
                            'default'   => '',
                        ),
                        array(
                            'id'           => 'order',
                            'type'         => 'select',
                            'title'        =>  esc_html__('Order', 'big-event'),
                            'options'      => array(
                                ''         =>  esc_html__('Select Order', 'big-event'),
                                'DESC'     =>  esc_html__('Descending ', 'big-event'),
                                'ASC'      =>  esc_html__('Ascending ', 'big-event'),                        
                            ),
                            'default'   => '',
                        ),
                        
                    ),
                ),
                
                // Event Ticket
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Ticket', 'big-event' )
                ),
                array(
                    'id'    => 'event_ticket',
                    'type'  => 'switcher',
                    'title' => 'Event Ticket',         
                    'default' => false,
                ),
                array(
                    'id'        => 'ticket_tab_title',
                    'type'      => 'text',
                    'default'   => 'Ticket',
                    'title'     => esc_html__( 'Tab Title', 'big-event' ),
                    'dependency'     => array( 'event_ticket', '==', 'true' ),
                ),
                array(
                    'id'        => 'ticket_type',
                    'type'      => 'text',
                    'default'   => 'Ticket Type',
                    'title'     => esc_html__( 'Ticket Type', 'big-event' ),
                    'dependency'     => array( 'event_ticket', '==', 'true' ),
                ),                        
                array(
                    'id'        => 'ticket_price',
                    'type'      => 'text',
                    'default'   => 'Price',
                    'title'     => esc_html__( 'Price', 'big-event' ),
                    'dependency'     => array( 'event_ticket', '==', 'true' ),
                ),                        
                array(
                    'id'        => 'ticket_buy',
                    'type'      => 'text',
                    'default'   => 'Buy',
                    'title'     => esc_html__( 'Buy', 'big-event' ),
                    'dependency'     => array( 'event_ticket', '==', 'true' ),
                ),
                array(
                    'id'                => 'event_tickets',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Event Tickets', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Ticket', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Ticket', 'big-event' ),
                    'dependency'     => array( 'event_ticket', '==', 'true' ),
                    'fields'            => array(
                        array(
                            'id'        => 'image',
                            'type'      => 'image',
                            'title'     => esc_html__( 'Image', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'limit',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Limit', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'price',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Price', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'btn_text',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Button Text', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'btn_url',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Button URL', 'big-event' )
                        ),                        
                    )
                ),
                
                // Event Detail Info
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Event Detail Info', 'big-event' )
                ),
                array(
                    'id'    => 'event_details',
                    'type'  => 'switcher',
                    'title'     => esc_html__( 'Event Detail Info', 'big-event' ),     
                    'default' => false,
                ),
                array(
                    'id'        => 'event_detail_title',
                    'type'      => 'text',
                    'default'   => 'Event Details',
                    'title'     => esc_html__( 'Title', 'big-event' ),
                    'dependency'     => array( 'event_details', '==', 'true' ),
                ),
                array(
                    'id'                => 'event_detail_info',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Event Info', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Info', 'big-event' ),
                    'dependency'        => array( 'event_details', '==', 'true' ),
                    'fields'            => array(
                        array(
                            'id'        => 'title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'description',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Description', 'big-event' )
                        ),                        
                    )
                ),
                array(
                    'id'    => 'gmap',
                    'type'  => 'switcher',
                    'title'     => esc_html__( 'Google Map', 'big-event' ),     
                    'default' => false,
                    'dependency'        => array( 'event_details', '==', 'true' ),
                ),
                array(
                    'id'        => 'gmap_title',
                    'type'      => 'text',
                    'default'   => 'Google Map',
                    'title'     => esc_html__( 'Google Map Title', 'big-event' ),
                    'dependency'     => array( 'event_details|gmap', '==|==', 'true|true' ),
                ),
                array(
                    'id'        => 'gmap_latutude',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Google Map Latutude', 'big-event' ),
                    'dependency'     => array( 'event_details|gmap', '==|==', 'true|true' ),
                ),
                array(
                    'id'        => 'gmap_longitude',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Google Map Longitude', 'big-event' ),
                    'dependency'     => array( 'event_details|gmap', '==|==', 'true|true' ),
                ),
                array(
                    'id'        => 'gmap_zoom',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Google Map Zoom', 'big-event' ),
                    'dependency'     => array( 'event_details|gmap', '==|==', 'true|true' ),
                ),
                array(
                    'id'        => 'gmap_icon',
                    'type'      => 'upload',
                    'title'     => esc_html__( 'Google Map Icon', 'big-event' ),
                    'dependency'     => array( 'event_details|gmap', '==|==', 'true|true' ),
                ),
                
                // Event Organizers
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Event Organizers', 'big-event' )
                ),
                array(
                    'id'    => 'event_organizers',
                    'type'  => 'switcher',
                    'title'     => esc_html__( 'Event Organizers', 'big-event' ),     
                    'default' => false,
                ),
                array(
                    'id'        => 'organizers_title',
                    'type'      => 'text',
                    'default'   => 'Event Organizers',
                    'title'     => esc_html__( 'Title', 'big-event' ),
                    'dependency'     => array( 'event_organizers', '==', 'true' ),
                ),                
                array(
                    'id'            => 'organizer_image',
                    'type'          => 'image',
                    'title'         => esc_html__( 'Organizer Image', 'big-event' ),
                    'add_title'     => esc_html__( 'Add Image', 'big-event' ),
                    'dependency'     => array( 'event_organizers', '==', 'true' ),
                ),
                array(
                    'id'                => 'organizer_info',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Organizer Info', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Info', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Info', 'big-event' ),
                    'dependency'        => array( 'event_organizers', '==', 'true' ),
                    'fields'            => array(
                        array(
                            'id'        => 'title',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Title', 'big-event' )
                        ),                        
                        array(
                            'id'        => 'description',
                            'type'      => 'text',
                            'title'     => esc_html__( 'Description', 'big-event' )
                        ),                        
                    ),
                ),
                array(
                    'id'        => 'organizer_desctitle',
                    'type'      => 'text',
                    'default'   => 'Description',
                    'title'     => esc_html__( 'Description', 'big-event' ),
                    'dependency'        => array( 'event_organizers', '==', 'true' ),
                ),
                array(
                    'id'        => 'organizer_description',
                    'type'      => 'textarea',
                    'title'     => esc_html__( 'Organizer Description', 'big-event' ),
                    'dependency'        => array( 'event_organizers', '==', 'true' ),
                ),
                
                // Event Sponsors
                array(
                    'type'          => 'subheading',
                    'content'       => esc_html__( 'Event Sponsors', 'big-event' )
                ),
                array(
                    'id'    => 'event_sponsors',
                    'type'  => 'switcher',
                    'title' => esc_html__( 'Event Sponsors', 'big-event' ),     
                    'default' => false,
                ),
                array(
                    'id'        => 'sponsors_title',
                    'type'      => 'text',
                    'default'   => 'Event Sponsors',
                    'title'     => esc_html__( 'Title', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                ),
                array(
                    'id'        => 'row1_title',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Row 1 Title', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                ),
                array(
                    'id'                => 'row1_sponsors',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Row 1 Sponsors', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Logo', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Logo', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                    'fields'            => array(                       
                        array(
                            'id'        => 'logo',
                            'type'      => 'image',
                            'title'     => esc_html__( 'Sponsors Logo', 'big-event' )
                        )
                    ),
                ),
                array(
                    'id'        => 'row2_title',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Row 2 Title', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                ),
                array(
                    'id'                => 'row2_sponsors',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Row 2 Sponsors', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Logo', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Logo', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                    'fields'            => array(                       
                        array(
                            'id'        => 'logo',
                            'type'      => 'image',
                            'title'     => esc_html__( 'Sponsors Logo', 'big-event' )
                        )
                    ),
                ),
                array(
                    'id'        => 'row3_title',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Row 3 Title', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                ),
                array(
                    'id'                => 'row3_sponsors',
                    'type'              => 'group',
                    'title'             => esc_html__( 'Row 3 Sponsors', 'big-event' ),
                    'button_title'      => esc_html__( 'Add New Logo', 'big-event' ),
                    'accordion_title'   => esc_html__( 'New Logo', 'big-event' ),
                    'dependency'     => array( 'event_sponsors', '==', 'true' ),
                    'fields'            => array(                       
                        array(
                            'id'        => 'logo',
                            'type'      => 'image',
                            'title'     => esc_html__( 'Sponsors Logo', 'big-event' )
                        )
                    ),
                ),
                
            )
        )
    )
);

CSFramework_Metabox::instance( $options );
