<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => esc_html__( 'Theme Options', 'big-event' ),
  'menu_type'       => 'menu', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'cs-framework',
  'ajax_save'       => false,
  'show_reset_all'  => false,
  'framework_title' => 'Big Event Options Panel <small>by Codestar</small>',
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();

/**
 * General Settings
 */

$options[]      = array(
    'name'      => 'be_general_settings',
    'title'     => esc_html__( 'General Settings', 'big-event' ),
    'icon'      => 'fa fa-cog',
    'fields'    => array(
        array(
            'id'            => 'be_is_box_layout',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Box Layout', 'big-event' ),
            'default'       => false
        ),
        array(
            'id'    => 'be_background_image',
            'type'  => 'background',
            'title' =>  esc_html__('Background Field','event-term'),
            'default' => array(
                'repeat'     => 'no-repeat',
                'position'   => 'center center',
                'attachment' => 'fixed',
                'size' => 'cover',
                'color'      => '#fff',
            ),
            'dependency' => array( 'be_is_box_layout', '==', 'true' ), 
        ),
        array(
            'id'            => 'be_menu_background_color',
            'type'          => 'color_picker',
            'default'       => '#ee0034',
            'title'         => esc_html__( 'Theme Primary Color', 'big-event' ),
        ),
        array(
            'id'            => 'be_secondary_color',
            'type'          => 'color_picker',
            'default'       => '#ffea00',
            'title'         => esc_html__( 'Theme Secondary Color', 'big-event' ),
        ),
        array(
            'type'          => 'subheading',
            'content'       => esc_html__( 'Header and Menu', 'big-event' )
        ),
        array(
            'id'            => 'be_site_logo',
            'type'          => 'image',
            'title'         => esc_html__( 'Site Logo', 'big-event' ),
            'add_title'     => esc_html__( 'Add Logo', 'big-event' )
        ),
        array(
            'id' => 'be_header_style',
            'type' => 'radio',
            'title' => esc_html__('Header Style', 'big-event'),
            'class' => 'horizontal',
            'options' => array(
                '1' => esc_html__('Header 1', 'big-event'),
                '2' => esc_html__('Header 2 (One Page Nav)', 'big-event'),
                '3' => esc_html__('Header 3', 'big-event'),
            ),
            'default' => '1',
            'attributes' => array(
                'data-depend-id' => 'be_header_style',
            ),
        ),         
        array(
            'id'            => 'be_transparent_menu',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Transparent Menu', 'big-event' ),
            'label'         => esc_html__( 'If you want to enable transparent menu, switch "on" to this button', 'big-event' ),
            'default'       => true,
            'dependency'   => array( 'be_header_style', 'any', '1,2' ),
        ),
        array(
            'id'            => 'be_transparent_menu_bg',
            'type'          => 'color_picker',
            'title'         => esc_html__( 'Transparent Menu Background Color', 'big-event' ),
            'dependency'   => array( 'be_header_style', 'any', '1,2' ),
        ),
        array(
            'id'            => 'be_is_menu_cart',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Mini Cart', 'big-event' ),
            'label'         => esc_html__( 'Do you want to display minicart?', 'big-event' ),
            'default'       => true,
        ),
        array(
            'id'            => 'be_is_buy_button',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Buy Button', 'big-event' ),
            'label'         => esc_html__( 'Do you want to display button?', 'big-event' ),
            'default'       => true,
        ),
        array(
            'id'            => 'be_buy_button_text',
            'type'          => 'textarea',
            'title'         => esc_html__( 'Buy Button Label', 'big-event' ),
            'sanitize'      => false,
            'dependency'    => array( 'be_is_buy_button', '==', 'true' )
        ),
        array(
            'id'            => 'be_buy_button_url',
            'type'          => 'text',
            'title'         => esc_html__( 'Buy Button URL', 'big-event' ),
            'dependency'    => array( 'be_is_buy_button', '==', 'true' )
        ),  
        array(
            'id'            => 'be_h3_contact_text',
            'type'          => 'wysiwyg',
            'title'         => esc_html__( 'Header 3 Contact Text', 'big-event' ),
        ),
        array(
            'type'          => 'subheading',
            'content'       => esc_html__( 'Header Counter and Breadcrumb', 'big-event' )
        ),
        array(
            'id'            => 'be_is_page_header',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Page Header Counter and Breadcrumb', 'big-event' ),
            'label'         => esc_html__( 'Do you want to display page header with breadcrumb?', 'big-event' ),
            'default'       => true
        ),
        array(
            'id'            => 'be_is_page_coundown',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Page Coundown', 'big-event' ),
            'label'         => esc_html__( 'Do you want to display page coundown?', 'big-event' ),
            'default'       => false,
            'dependency'    => array( 'be_is_page_header', '==', 'true' )
        ),
        array(
            'id'            => 'be_coundown_date',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Date', 'big-event' ),
            'desc'          => esc_html__( 'Ex: 24', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_coundown_month',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Month', 'big-event' ),
            'desc'          => esc_html__( 'Ex: December', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_coundown_year',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Year', 'big-event' ),
            'desc'          => esc_html__( 'Ex: 2017', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_coundown_subtitle',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Subtitle', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_coundown_title',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Title', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_coundown_time',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Date Time', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' ),
            'desc'          => esc_html__( 'To display event counter properly it is must needed to enter event date time in this format- mm/dd/yyyy 17:00:00', 'big-event' ),
        ),
        array(
            'id'            => 'be_time_offset',
            'type'          => 'text',
            'title'         => esc_html__( 'Time GMT UTC offset', 'big-event' ),
            'default'       => '-5',
            'desc'          => esc_html__( 'ex: -5', 'big-event' )
        ),        
        array(
            'id'            => 'be_coundown_booking_text',
            'type'          => 'text',
            'title'         => esc_html__( 'Booking Now Button Text', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_coundown_booking_url',
            'type'          => 'text',
            'title'         => esc_html__( 'Booking Now Button URL', 'big-event' ),
            'dependency'    => array( 'be_is_page_coundown|be_is_page_header', '==|==', 'true|true' )
        ),
        array(
            'id'            => 'be_page_header_bg',
            'type'          => 'upload',
            'title'         => esc_html__( 'Page Background', 'big-event' ),
            'dependency'    => array( 'be_is_page_header', '==', 'true' )
        ),
    ),
);



/**
 * Typography
 */
$options[] = array(
    'name'      => 'be_typography',
    'title'     => esc_html__( 'Typography', 'big-event' ),
    'icon'      => 'fa fa-font',
    'fields'    => array(
        array(
            'type'      => 'heading',
            'content'   => esc_html__( 'Body Typography', 'big-event' )
        ),
        array(
            'id'        => 'be_body_font_family',
            'type'      => 'typography',
            'title'     => esc_html__( 'Body Font Family', 'big-event' ),
            'default'   => array(
                'family'    => 'Poppins',
                'font'      => 'google'
            ),
            'variant'   => false
        ),
        array(
            'id'        => 'be_body_font_size',
            'type'      => 'number',
            'title'     => esc_html__( 'Body Font Size', 'big-event' ),
            'default'   => '15',
            'after'     => '<i class="cs-text-muted"> (px)</i>'
        ),
        array(
            'type'      => 'heading',
            'content'   => esc_html__( 'Title Typography', 'big-event' )
        ),
        array(
            'id'        => 'be_title_font_family',
            'type'      => 'typography',
            'title'     => esc_html__( 'Title Font Family', 'big-event' ),
            'default'   => array(
                'family'    => 'Poppins',
                'font'      => 'google'
            ),
            'variant'   => false
        ),
        array(
            'id'        => 'be_title_font_style',
            'type'      => 'select',
            'title'     => esc_html__( 'Title Font Style', 'big-event' ),
            'options'   => array(
                'normal'    => esc_html__( 'Normal', 'big-event' ),
                'italic'    => esc_html__( 'Italic', 'big-event' ),
                'oblique'   => esc_html__( 'Oblique', 'big-event' )
            ),
            'default'   => 'normal'
        ),
        array(
            'id'             => 'be_title_text_transform',
            'type'           => 'select',
            'title'          => esc_html__('Title text-transform:', 'event-term'),
            'options'     => array(
                'uppercase'  => esc_html__('Uppercase', 'event-term'),
                'none'       => esc_html__('None', 'event-term'),
                'capitalize' => esc_html__('Capitalize', 'event-term'),                
                'lowercase'  => esc_html__('Lowercase', 'event-term'),
            ),
            'default'  => 'uppercase',
        ),
        array(
            'type'      => 'heading',
            'content'   => esc_html__( 'Menu Typography', 'big-event' )
        ),
        array(
            'id'        => 'be_menu_font_family',
            'type'      => 'typography',
            'title'     => esc_html__( 'Menu Font Family', 'big-event' ),
            'default'   => array(
                'family'    => 'Montserrat',
                'font'      => 'google'
            ),
            'variant'   => false
        ),
        array(
            'id'        => 'be_menu_font_style',
            'type'      => 'select',
            'title'     => esc_html__( 'Menu Font Style', 'big-event' ),
            'options'   => array(
                'normal'    => esc_html__( 'Normal', 'big-event' ),
                'italic'    => esc_html__( 'Italic', 'big-event' ),
                'oblique'   => esc_html__( 'Oblique', 'big-event' )
            ),
            'default'   => 'normal'
        ),
        array(
            'id'        => 'be_menu_text_transform',
            'type'      => 'select',
            'title'     => esc_html__( 'Menu Text Transform', 'big-event' ),
            'options'   => array(
                'none'          => esc_html__( 'None', 'big-event' ),
                'uppercase'     => esc_html__( 'Uppercase', 'big-event' ),
                'capitalize'    => esc_html__( 'Capitalize', 'big-event' ),
                'lowercase'     => esc_html__( 'Lowercase', 'big-event' )
            )
        )
    )
);





/**
 * Event Info
 */

$options[] = array(
    'name'      => 'be_event_info',
    'title'     => esc_html__( 'Banner Event Info', 'big-event' ),
    'icon'      => 'fa fa-paper-plane',
    'fields'    => array(
        array(
            'type'      => 'heading',
            'content'   => esc_html__( 'Default Banner Event Info', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_image',
            'type'          => 'upload',
            'title'         => esc_html__( 'Banner Background Image', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_title',
            'type'          => 'text',
            'title'         => esc_html__( 'Event Title', 'big-event' ),
        ),
        array(
            'id'            => 'be_banner_subtitle',
            'type'          => 'text',
            'title'         => esc_html__( 'Event Subtitle', 'big-event' ),
        ),
        array(
            'id'            => 'be_banner_date',
            'type'          => 'text',
            'title'         => esc_html__( 'Banner Date', 'big-event' ),
            'desc'          => esc_html__( 'Ex: 24', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_month',
            'type'          => 'text',
            'title'         => esc_html__( 'Event Month', 'big-event' ),
            'desc'          => esc_html__( 'Event Month ex: December', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_year',
            'type'          => 'text',
            'title'         => esc_html__( 'Event Year', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_date_duration',
            'type'          => 'text',
            'title'         => esc_html__( 'Event Duration Date', 'big-event' ),
            'desc'          => esc_html__( 'For Banner 2', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_location',
            'type'          => 'text',
            'title'         => esc_html__( 'Event Location', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_coundown_time',
            'type'          => 'text',
            'title'         => esc_html__( 'Coundown Date Time', 'big-event' ),
            'desc'          => esc_html__( 'To display event counter properly it is must needed to enter event date time in this format- mm/dd/yyyy 17:00:00', 'big-event' ),
        ),
        array(
            'id'            => 'be_banner_offset',
            'type'          => 'text',
            'title'         => esc_html__( 'Time GMT UTC offset', 'big-event' ),
            'default'       => '-5',
            'desc'          => esc_html__( 'ex: -5', 'big-event' )
        ),        
        array(
            'id'            => 'be_banner_speaker',
            'type'          => 'text',
            'title'         => esc_html__( 'Banner Speaker', 'big-event' ),
            'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
        ),
        array(
            'id'            => 'be_banner_tickets',
            'type'          => 'text',
            'title'         => esc_html__( 'Banner Tickets', 'big-event' ),
            'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
        ),
        array(
            'id'            => 'be_banner_setas',
            'type'          => 'text',
            'title'         => esc_html__( 'Banner Seats', 'big-event' ),
            'dependency'    => array( 'be_is_theme_event|be_is_banner', '==|==', 'true|true' ),
            'desc'          => esc_html__( 'For Banner 11', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_register_text',
            'type'          => 'text',
            'title'         => esc_html__( 'Register Button Text', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_register_url',
            'type'          => 'text',
            'title'         => esc_html__( 'Register Button URL', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_booking_now_text',
            'type'          => 'text',
            'title'         => esc_html__( 'Booking Now Button Text', 'big-event' )
        ),
        array(
            'id'            => 'be_banner_booking_now_url',
            'type'          => 'text',
            'title'         => esc_html__( 'Booking Now Button URL', 'big-event' )
        )
    )
);


/**
 * Event Schedule
 */
if( function_exists( 'cs_get_option' ) ) :
    function big_event_schedule_per_date() {
        $be_schedules = array();

        $be_schedules[] = array(
            'type'              => 'heading',
            'content'           => esc_html__( 'Create Event Schedule', 'big-event' )
        );

        $be_schedules[] = array(
            'id'                => 'be_event_schedules',
            'type'              => 'group',
            'help'              => esc_html__( 'Please hit save after create an event schedule to visible per date schedule', 'big-event' ),
            'title'             => esc_html__( 'Create Date', 'big-event' ),
            'button_title'      => esc_html__( 'Add New Date', 'big-event' ),
            'accordion_title'   => esc_html__( 'Event Date', 'big-event' ),
            'fields'            => array(
                array(
                    'id'        => 'event_day',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Day', 'big-event' )
                ),
                array(
                    'id'        => 'event_date',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Date', 'big-event' )
                ),
                array(
                    'id'        => 'event_month',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Month', 'big-event' )
                ),
                array(
                    'id'        => 'event_year',
                    'type'      => 'text',
                    'title'     => esc_html__( 'Event Year', 'big-event' )
                ),
            )
        );
        $be_event_schedules = cs_get_option( 'be_event_schedules' );

        if( $be_event_schedules ) :
            $i = 1;
            $be_schedules[] = array(
                'type'              => 'heading',
                'content'           => esc_html__( 'Per Date Schedule', 'big-event' )
            );

        foreach( $be_event_schedules as $be_event_schedule ) :
            $be_schedules[] = array(
                'id'                => 'be_per_date_schedules_' . $i,
                'type'              => 'group',
                'title'             => $be_event_schedule['event_date'] . ' ' . $be_event_schedule['event_month'] . ', ' . $be_event_schedule['event_year'] . ' Schedule',
                'button_title'      => esc_html__( 'Add New Schedule', 'big-event' ),
                'accordion_title'   => esc_html__( 'Schedule', 'big-event' ),
                'fields'            => array(
                    array(
                        'id'            => 'be_event_per_date_schedules_time',
                        'type'          => 'text',
                        'title'         => esc_html__( 'Schedule Time', 'big-event' )
                    ),
                    array(
                        'id'            => 'be_event_per_date_schedules_session',
                        'type'          => 'text',
                        'title'         => esc_html__( 'Schedule Session', 'big-event' )
                    ),
                    array(
                        'id'            => 'surl',
                        'type'          => 'text',
                        'title'         => esc_html__( 'Session Detail URL', 'big-event' )
                    ),
                    array(
                        'id'            => 'be_event_per_date_schedules_speaker',
                        'type'          => 'select',
                        'title'         => esc_html__( 'Schedule Speaker', 'big-event' ),
                        'options'       => 'posts',
                        'query_args'    => array(
                            'post_type'     => 'speakers',
                            'nopaging'      => true
                        ),
                        'default_option' => esc_html__( 'Select Speakers', 'big-event' ),
                        'attributes'    => array(
                            'multiple'  => 'multiple',
                            'style'    => 'width: 200px; height: 200px;'
                        )
                    ),
                    array(
                        'id'            => 'be_event_per_date_schedules_venue',
                        'type'          => 'text',
                        'title'         => esc_html__( 'Schedule Venue', 'big-event' )
                    ),
                    array(
                        'id'            => 'be_epds_image',
                        'type'          => 'image',
                        'title'         => esc_html__( 'Schedule Image', 'big-event' )
                    ),
                    array(
                        'id'            => 'be_epds_detail',
                        'type'          => 'textarea',
                        'title'         => esc_html__( 'Schedule Detail', 'big-event' ),
                        'sanitize'      => false,
                    ),
                )
            );
        $i++;
        endforeach;

        endif;

        return $be_schedules;
    }
endif;

/**
 * Event Schedule Settings
 */

$options[]      = array(
    'name'      => 'be_event_schedule_settings',
    'title'     => esc_html__( 'Event Schedule', 'big-event' ),
    'icon'      => 'fa fa-calendar-o',
    'fields'    => big_event_schedule_per_date()
);


/**
 * Custom Post Settings
 */
$options[]      = array(
    'name'      => 'be_custom_post_settings',
    'title'     => esc_html__( 'Custom Post Settings', 'big-event' ),
    'icon'      => 'fa fa-paste',
    'fields'    => array(
        array(
            'type'      => 'heading',
            'content'   => esc_html__( 'Custom Post Type Settings', 'big-event' )
        ),
        array(
            'id'        => 'be_event_post_name',
            'type'      => 'text',
            'title'     => esc_html__( 'Event post type rewrite name', 'big-event' ),
            'desc'      => esc_html__( 'Here you can define your own name to appear as part of event name. By default "Event" is used.', 'big-event' )
        ),
        array(
            'id'        => 'be_event_post_slug',
            'type'      => 'text',
            'title'     => esc_html__( 'Event post type rewrite slug', 'big-event' ),
            'desc'      => esc_html__( 'Here you can define your own slug to appear as part of event URL. By default /event/ is used.', 'big-event' )
        ),
        array(
            'id'        => 'be_speaker_post_name',
            'type'      => 'text',
            'title'     => esc_html__( 'Speaker post type rewrite name', 'big-event' ),
            'desc'      => esc_html__( 'Here you can define your own name to appear as part of speaker name. By default "Speaker" is used.', 'big-event' )
        ),
        array(
            'id'        => 'be_speakers_post_slug',
            'type'      => 'text',
            'title'     => esc_html__( 'Speakers post type rewrite slug', 'big-event' ),
            'desc'      => esc_html__( 'Here you can define your own slug to appear as part of speakers URL. By default /speakers/ is used.', 'big-event' )
        ),        
    )
);


/**
 * Google Map Settings
 */
$options[]      = array(
    'name'      => 'be_google_map_settings',
    'title'     => esc_html__( 'Google Map', 'big-event' ),
    'icon'      => 'fa fa-globe',
    'fields'    => array(
        array(
            'type'      => 'heading',
            'content'   => esc_html__( 'Google Map Options', 'big-event' )
        ),
        array(
            'id'        => 'be_google_map_api',
            'type'      => 'text',
            'title'     => esc_html__( 'Google Map API key', 'big-event' ),
            'desc'      => esc_html__( 'Create your google map api from https://developers.google.com/maps/documentation/javascript/tutorial', 'big-event' )
        )
    )
);


/**
 * Footer Settings
 */

$options[]      = array(
    'name'      => 'be_footer_settings',
    'title'     => esc_html__( 'Footer Settings', 'big-event' ),
    'icon'      => 'fa fa-bookmark',
    'fields'    => array(
        array(
            'type'          => 'heading',
            'content'       => esc_html__( 'Newsletter', 'big-event' )
        ),
        array(
            'id'            => 'be_is_footer_newsletter',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Newsletter', 'big-event' ),
            'label'         => esc_html__( 'Do you want to display page newsletter?', 'big-event' ),
            'default'       => true
        ),
        array(
            'type'          => 'heading',
            'content'       => esc_html__( 'Footer', 'big-event' )
        ),
        array(
            'id'            => 'be_is_footer',
            'type'          => 'switcher',
            'title'         => esc_html__( 'Footer', 'big-event' ),
            'label'         => esc_html__( 'Do you want to display footer?', 'big-event' ),
            'default'       => true
        ),
        array(
            'id' => 'be_footer_style',
            'type' => 'radio',
            'title' => esc_html__('Footer Style', 'big-event'),
            'class' => 'horizontal',
            'options' => array(
                '1' => esc_html__('Footer 1', 'big-event'),
                '2' => esc_html__('Footer 2', 'big-event'),
            ),
            'default' => '1',
            'attributes' => array(
                'data-depend-id' => 'be_footer_style',
            ),
        ), 
        array(
            'id'            => 'be_footer_bg',
            'type'          => 'upload',
            'title'         => esc_html__( 'Footer Background', 'big-event' ),
            'settings'      => array(
                'upload_type'   => 'image',
                'button_title'  => 'Upload',
                'frame_title'   => esc_html__('Select an image','big-event' ),
                'insert_title'  => esc_html__('Use this image','big-event' ),
            ),
        ),
        array(
            'id'            => 'be_footer_logo',
            'type'          => 'upload',
            'title'         => esc_html__( 'Footer Logo', 'big-event' ),
            'settings'      => array(
                'upload_type'   => 'image',
                'button_title'  => 'Upload',
                'frame_title'   => esc_html__('Select an image','big-event' ),
                'insert_title'  => esc_html__('Use this image','big-event' ),
            ),
        ),
        array(
            'id'              => 'be_footer_social_profiles',
            'type'            => 'group',
            'title'           => esc_html__( 'Social Profile', 'big-event' ),
            'button_title'    => esc_html__( 'Add New Profile', 'big-event' ),
            'accordion_title' => esc_html__( 'Add New Social Profile', 'big-event' ),
            'fields'          => array(
                array(
                    'id'    => 'icon',
                    'type'  => 'icon',
                    'title' => esc_html__( 'Social Icon', 'big-event' ),
                ),
                array(
                    'id'    => 'url',
                    'type'  => 'text',
                    'title' => esc_html__( 'Social URL', 'big-event' ),
                ),
            ),
        ),
        array(
            'id'            => 'be_copyright_section',
            'type'          => 'wysiwyg',
            'desc'          => esc_html( 'Write your copyright text for footer. It also supports HTML tag.', 'big-event' ),
            'title'         => esc_html__( 'Copyright Text', 'big-event' )
        ),
    ),
);


/**
 * Backup Options
 */
$options[]   = array(
    'name'     => 'be_backup_section',
    'title'    => esc_html__( 'Backup', 'big-event' ),
    'icon'     => 'fa fa-shield',
    'fields'   => array(

        array(
            'type'    => 'notice',
            'class'   => 'warning',
            'content' => esc_html__( 'You can save your current options. Download a Backup and Import.', 'big-event' ),
        ),

        array(
            'type'    => 'backup',
        ),

    )
);

CSFramework::instance( $settings, $options );
