(function($){
  'use strict';
  jQuery( document ).ready(function() {

    var map             = jQuery('#map_canvas');
    var mapIcon         = map.data('map-icon');
    var mapLatitute     = map.data('map-latitute');
    var mapLongitute    = map.data('map-longitude');
    var mapZoom         = map.data('map-zoom');
    if( map.length ) {
        google.maps.event.addDomListener(window, "load", big_event_travel_map);
    }

    function big_event_travel_map() {

    //Travel map
    var styleArray = [
      {
        "featureType": "water",
        "elementType": "geometry.fill",
        "stylers": [
          {
            "color": "#65ac4c"
          }
        ]
      }
    ];

    var mapOptions = {
      center: new google.maps.LatLng(mapLatitute,mapLongitute),
      zoom: mapZoom,
      styles: styleArray,
      scrollwheel: false,
      backgroundColor: 'transparent',
        mapTypeControl: false,          
      mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    var map = new google.maps.Map(document.getElementById("map_canvas"),
      mapOptions);        
    var myLatlng = new google.maps.LatLng(mapLatitute,mapLongitute);      
    var marker = new google.maps.Marker({
      position: myLatlng,
      map: map,
      icon: mapIcon
    });

    }

  });
})(jQuery);