<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package big-event
 * @author CodexCoder
 * @since 1.0.0
 * @version 1.0.0
 */

get_header(); ?>

	<section class="featured-event padding-120">
		<div class="container">
			<div class="row">
				<div class="">

					<?php
					if ( have_posts() ) :

						/* Start the Loop */
						while ( have_posts() ) : the_post();
                            $eoptions = get_post_meta( get_the_ID(), '_be_event_options', true );
                            $event_date    = isset( $eoptions['event_date'] ) ? $eoptions['event_date'] : '';
                            $event_month   = isset( $eoptions['event_month'] ) ? $eoptions['event_month'] : '';
                            $time   = isset( $eoptions['time'] ) ? $eoptions['time'] : '';
                            $location   = isset( $eoptions['location'] ) ? $eoptions['location'] : '';
                            $event_short_desc   = isset( $eoptions['event_short_desc'] ) ? $eoptions['event_short_desc'] : '';
                            $organizers_name = isset( $eoptions['event_organizers_name'] ) ? $eoptions['event_organizers_name'] : '';
                            $organizer_designation = isset( $eoptions['organizer_designation'] ) ? $eoptions['organizer_designation'] : '';
                            $ticket_price   = isset( $eoptions['event_ticket_price'] ) ? $eoptions['event_ticket_price'] : '';
                            $ticket_btntext   = isset( $eoptions['ticket_btntext'] ) ? $eoptions['ticket_btntext'] : '';
                            $ticket_url   = isset( $eoptions['ticket_url'] ) ? $eoptions['ticket_url'] : '';

                            $organizer_image = isset( $eoptions['event_organizer_image'] ) ? $eoptions['event_organizer_image'] : '';
                            $organizer_image_attr = wp_get_attachment_image_src($organizer_image, 'big-event-popular-posts-thumb');
                            $organizer_image_alt = get_post_meta($organizer_image, '_wp_attachment_image_alt', true);
                    ?>
                        <div class="col-md-4 col-sm-6">
                            <div class="event-item">
                                <div class="event-item-inner">
                                    <div class="event-thumb">
                                        <a href="<?php the_permalink() ?>"><?php the_post_thumbnail('big-event-gallery-three-column') ?></a> 
                                        <div class="event-date">
                                            <div class="event-date-inner">
                                                <?php 
                                                if (!empty($event_date)):
                                                    echo '<h4>'.esc_html($event_date).'</h4> ';
                                                endif;

                                                if (!empty($event_month)):
                                                    echo '<p>'.esc_html($event_month).'</p> ';
                                                endif;
                                                ?>
                                            </div>
                                        </div><!--event-date end-->                                     
                                    </div><!--event-thumb end-->
                                    <div class="event-content event-item-padding">
                                        <?php the_title('<h4><a href="'.get_the_permalink().'">', '</a></h4>'); ?>
                                        <ul class="time-location">
                                            <?php 
                                            if (!empty($time)):
                                                echo '<li><span>'.esc_html('Time','big-event').' :</span> '.esc_html($time).'</li>';
                                            endif;
                                            if (!empty($location)):
                                                echo '<li><span>'.esc_html('Location','big-event').' :</span> '.esc_html($location).'</li>';
                                            endif;
                                            ?>
                                        </ul>
                                        <?php 
                                        if (!empty($event_short_desc)):
                                            echo '<p>'.esc_html($event_short_desc).'</p>';
                                        endif;
                                        ?>                                            
                                        <div class="organizer-ticket">
                                            <div class="organizer">
                                                <?php if (!empty($organizer_image)): ?>
                                                <div class="orgranizer-img">
                                                    <img src="<?php echo esc_url($organizer_image_attr[0]) ?>" alt="<?php echo esc_attr($organizer_image_alt) ?>">
                                                </div>
                                                <?php endif;  ?>
                                                <div class="organizer-intro">
                                                    <?php  
                                                    if (!empty($organizers_name)):
                                                        echo '<span class="organizer-name">'.esc_html($organizers_name).'</span>';
                                                    endif;
                                                    if (!empty($organizer_designation)):
                                                        echo '<span class="organizer-desig">'.esc_html($organizer_designation).'</span>';
                                                    endif;
                                                    ?>                          
                                                </div>
                                            </div><!--organizer end-->
                                            <div class="event-price">
                                                <?php  
                                                if (!empty($ticket_price)):
                                                    echo '<span class="ticket-price">'.esc_html($ticket_price).'</span>';
                                                endif;
                                                if (!empty($ticket_btntext)):
                                                    echo '<span class="ticket"><a href="'.esc_url($ticket_url).'">'.esc_html($ticket_btntext).'</a></span>';
                                                endif;
                                                ?>                 
                                            </div><!--event-price end-->
                                        </div><!--organizer-ticket end-->
                                    </div><!--event-content end-->
                                </div><!--event-item-inner end-->
                            </div><!--event-item end-->                    
                        </div>                     
                    <?php
						endwhile;

						big_event_numeric_pagination();

					else :

						get_template_part( 'template-parts/posts/content', 'none' );

					endif; ?>

				</div>

			</div>
		</div>
	</section>

<?php
get_footer();
