<?php
/**
 * Plugin Name: Big Event Custom Post
 * Plugin URI: https://themeforest.net/user/codexcoder
 * Description: This plugin is for Big Event registration and custom post type
 * Author: CodexCoder
 * Author URI: http://codexcoder.com
 * Version: 2.0.1
 * Text Domain: big-event-custom-post
 */

if( ! class_exists( 'Big_Event_Event_Post_Type' ) ) :
class Big_Event_Event_Post_Type {
	public static $post_type 		= 'event';
	public static $menu_position 	= 5;
    public static $taxonomy 		= 'event_categories';
    public static $tag = 'event_tags';

	public static function register() {

		// Title
		$labels = array(
			'name'					=> esc_html__( 'Event', 'big-event-custom-post' ),
			'singular_name'			=> esc_html__( 'Event', 'big-event-custom-post' ),
			'menu_name'				=> esc_html__( 'Events', 'big-event-custom-post' ),
			'name_admin_bar'		=> esc_html__( 'Event', 'big-event-custom-post' ),
			'add_new'				=> esc_html__( 'Add New', 'big-event-custom-post' ),
			'add_new_item'			=> esc_html__( 'Add New Event', 'big-event-custom-post' ),
			'new_item'				=> esc_html__( 'New Event', 'big-event-custom-post' ),
			'edit_item'				=> esc_html__( 'Edit Event', 'big-event-custom-post' ),
			'view_item'				=> esc_html__( 'View Event', 'big-event-custom-post' ),
			'all_items'				=> esc_html__( 'All Events', 'big-event-custom-post' ),
			'search_items'			=> esc_html__( 'Search Events', 'big-event-custom-post' ),
			'parent_item_colorn'	=> '',
			'not_found'				=> esc_html__( 'No Event found', 'big-event-custom-post' ),
			'not_found_in_trash'	=> esc_html__( 'No Event found in Trash', 'big-event-custom-post' )
		);

		// Options
		$args = array(
			'labels'				=> $labels,
			'description'			=> esc_html__( 'Add new show from here', 'big-event-custom-post' ),
			'public'				=> true,
			'public_queryable'		=> true,
			'show_ui'				=> true,
			'show_in_menu'			=> true,
			'query_var'				=> true,
			'rewrite'				=> array( 'slug' => self::$post_type ),
			'capability_type'		=> 'post',
			'has_archive'			=> true,
			'hierarchical'			=> false,
			'menu_position'			=> self::$menu_position,
			'menu_icon'				=> 'dashicons-calendar-alt',
			'supports'				=> array( 'title', 'editor', 'thumbnail' )
		);
		$args = apply_filters( 'presscore_post_type_' . self::$post_type . '_args' , $args );

		register_post_type( self::$post_type, $args );
		flush_rewrite_rules();


        /* setup taxonomy */

        // titles
        $texanomy_labels = array(
	        'name'             => esc_html__( 'Event Categories',        'big-event-custom-post' ),
	        'singular_name'    => esc_html__( 'Event Category',          'big-event-custom-post' ),
	        'all_items'        => esc_html__( 'Event Categories',        'big-event-custom-post' ),
	        'parent_item'      => esc_html__( 'Parent Event Category',   'big-event-custom-post' ),
	        'parent_item_colon'=> esc_html__( 'Parent Event Category:',  'big-event-custom-post' ),
	        'edit_item'        => esc_html__( 'Edit Category',          'big-event-custom-post' ), 
	        'update_item'      => esc_html__( 'Update Category',        'big-event-custom-post' ),
	        'add_new_item'     => esc_html__( 'Add New Event Category',  'big-event-custom-post' ),
	        'new_item_name'    => esc_html__( 'New Event Name',          'big-event-custom-post' ),
	        'menu_name'        => esc_html__( 'Event Categories',        'big-event-custom-post' )
        );

        $taxonomy_args = array(
            'hierarchical'          => true,
            'public'                => true,
            'labels'                => $texanomy_labels,
            'show_ui'               => true,
            'rewrite'               => array('slug' => 'event_categories'),
            'show_admin_column'	=> true,
        );

        $taxonomy_args = apply_filters( 'presscore_taxonomy_' . self::$taxonomy . '_args', $taxonomy_args );

        register_taxonomy( self::$taxonomy, array( self::$post_type ), $taxonomy_args );
        
        /* setup tags */
	    $tags_labels = array(
	      'name' => esc_html__( 'Event Tags', 'big-event-custom-post' ),
	      'singular_name' => esc_html__( 'Tag', 'big-event-custom-post' ),
	      'search_items' =>  esc_html__( 'Search Tags', 'big-event-custom-post' ),
	      'popular_items' => esc_html__( 'Popular Tags', 'big-event-custom-post' ),
	      'all_items' => esc_html__( 'All Tags', 'big-event-custom-post' ),
	      'parent_item' => null,
	      'parent_item_colon' => null,
	      'edit_item' => esc_html__( 'Edit Tag', 'big-event-custom-post' ), 
	      'update_item' => esc_html__( 'Update Tag', 'big-event-custom-post' ),
	      'add_new_item' => esc_html__( 'Add New Tag', 'big-event-custom-post' ),
	      'new_item_name' => esc_html__( 'New Tag Name', 'big-event-custom-post' ),
	      'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'big-event-custom-post' ),
	      'add_or_remove_items' => esc_html__( 'Add or remove tags', 'big-event-custom-post' ),
	      'choose_from_most_used' => esc_html__( 'Choose from the most used tags', 'big-event-custom-post' ),
	      'menu_name' => esc_html__( 'Event Tags', 'big-event-custom-post' ),
	    );
	    $tag_args = array(
	        'hierarchical' => false,
	        'labels' => $tags_labels,
	        'show_ui' => true,
	        'update_count_callback' => '_update_post_term_count',
	        'query_var' => true,
	        'rewrite' => array( 'slug' => 'event_tags' ),
	    );
	    register_taxonomy( self::$tag, array( self::$post_type ), $tag_args );        
	}
}
endif;


if( ! class_exists( 'Big_Event_Speakers_Post_Type' ) ) :
class Big_Event_Speakers_Post_Type {
	public static $post_type 		= 'speakers';
	public static $menu_position 	= 6;
    public static $taxonomy 		= 'speakers_category';
    public static $tag              = 'speakers_tag';

	public static function register() {

		// Title
		$labels = array(
			'name'					=> esc_html__( 'Speaker', 'big-event-custom-post' ),
			'singular_name'			=> esc_html__( 'Speaker', 'big-event-custom-post' ),
			'menu_name'				=> esc_html__( 'Speakers', 'big-event-custom-post' ),
			'name_admin_bar'		=> esc_html__( 'Speaker', 'big-event-custom-post' ),
			'add_new'				=> esc_html__( 'Add New', 'big-event-custom-post' ),
			'add_new_item'			=> esc_html__( 'Add New Speaker', 'big-event-custom-post' ),
			'new_item'				=> esc_html__( 'New Speaker', 'big-event-custom-post' ),
			'edit_item'				=> esc_html__( 'Edit Speaker', 'big-event-custom-post' ),
			'view_item'				=> esc_html__( 'View Speaker', 'big-event-custom-post' ),
			'all_items'				=> esc_html__( 'All Speakers', 'big-event-custom-post' ),
			'search_items'			=> esc_html__( 'Search Speakers', 'big-event-custom-post' ),
			'parent_item_colorn'	=> '',
			'not_found'				=> esc_html__( 'No Speakers found', 'big-event-custom-post' ),
			'not_found_in_trash'	=> esc_html__( 'No Speakers found in Trash', 'big-event-custom-post' )
		);

		// Options
		$args = array(
			'labels'				=> $labels,
			'description'			=> esc_html__( 'Add New Speaker from here', 'big-event-custom-post' ),
			'public'				=> true,
			'public_queryable'		=> true,
			'show_ui'				=> true,
			'show_in_menu'			=> true,
			'query_var'				=> true,
			'rewrite'				=> array( 'slug' => self::$post_type ),
			'capability_type'		=> 'post',
			'has_archive'			=> true,
			'hierarchical'			=> false,
			'menu_position'			=> self::$menu_position,
			'menu_icon'				=> 'dashicons-groups',
			'supports'				=> array( 'title', 'editor', 'thumbnail' )
		);

		$args = apply_filters( 'presscore_post_type_' . self::$post_type . '_args' , $args );

		register_post_type( self::$post_type, $args );
		flush_rewrite_rules();


        /* setup taxonomy */

        // titles
        $texanomy_labels = array(
	        'name'             => esc_html__( 'Speaker Categories',        'big-event-custom-post' ),
	        'singular_name'    => esc_html__( 'Speaker Category',          'big-event-custom-post' ),
	        'all_items'        => esc_html__( 'Speaker Categories',        'big-event-custom-post' ),
	        'parent_item'      => esc_html__( 'Parent Speaker Category',   'big-event-custom-post' ),
	        'parent_item_colon'=> esc_html__( 'Parent Speaker Category:',  'big-event-custom-post' ),
	        'edit_item'        => esc_html__( 'Edit Category',             'big-event-custom-post' ), 
	        'update_item'      => esc_html__( 'Update Category',           'big-event-custom-post' ),
	        'add_new_item'     => esc_html__( 'Add New Speaker Category',  'big-event-custom-post' ),
	        'new_item_name'    => esc_html__( 'New Speaker Name',          'big-event-custom-post' ),
	        'menu_name'        => esc_html__( 'Speaker Categories',        'big-event-custom-post' )
        );

        $taxonomy_args = array(
            'hierarchical'          => true,
            'public'                => true,
            'labels'                => $texanomy_labels,
            'show_ui'               => true,
            'rewrite'               => array('slug' => 'speakers_category'),
            'show_admin_column'     => true,
        );

        $taxonomy_args = apply_filters( 'presscore_taxonomy_' . self::$taxonomy . '_args', $taxonomy_args );

        register_taxonomy( self::$taxonomy, array( self::$post_type ), $taxonomy_args );
        
        /* setup tags */
	    $tags_labels = array(
	      'name' => esc_html__( 'Speaker Tags', 'big-event-custom-post' ),
	      'singular_name' => esc_html__( 'Tag', 'big-event-custom-post' ),
	      'search_items' =>  esc_html__( 'Search Tags', 'big-event-custom-post' ),
	      'popular_items' => esc_html__( 'Popular Tags', 'big-event-custom-post' ),
	      'all_items' => esc_html__( 'All Tags', 'big-event-custom-post' ),
	      'parent_item' => null,
	      'parent_item_colon' => null,
	      'edit_item' => esc_html__( 'Edit Tag', 'big-event-custom-post' ), 
	      'update_item' => esc_html__( 'Update Tag', 'big-event-custom-post' ),
	      'add_new_item' => esc_html__( 'Add New Tag', 'big-event-custom-post' ),
	      'new_item_name' => esc_html__( 'New Tag Name', 'big-event-custom-post' ),
	      'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'big-event-custom-post' ),
	      'add_or_remove_items' => esc_html__( 'Add or remove tags', 'big-event-custom-post' ),
	      'choose_from_most_used' => esc_html__( 'Choose from the most used tags', 'big-event-custom-post' ),
	      'menu_name' => esc_html__( 'Speaker Tags', 'big-event-custom-post' ),
	    );
	    $tag_args = array(
	        'hierarchical' => true,
	        'labels' => $tags_labels,
	        'show_ui' => true,
	        'update_count_callback' => '_update_post_term_count',
	        'query_var' => true,
	        'rewrite' => array( 'slug' => 'speakers_tag' ),
	    );
	    register_taxonomy( self::$tag, array( self::$post_type ), $tag_args );  
	}
}
endif;


/**
 * Pricing Table Post Type
 */

if( ! class_exists( 'Big_Event_Pricing_Table_Post_Type' ) ) :
class Big_Event_Pricing_Table_Post_Type {
	public static $post_type 		= 'price-table';
	public static $menu_position	= 7;
    public static $taxonomy 		= 'pricing_category';

	public static function register() {

		// Title
		$labels = array(
			'name'					=> esc_html__( 'Pricing Tables', 'big-event-custom-post' ),
			'singular_name'			=> esc_html__( 'Pricing Table', 'big-event-custom-post' ),
			'add_new'				=> esc_html__( 'Add New', 'big-event-custom-post' ),
			'add_new_item'			=> esc_html__( 'Add New Pricing Table', 'big-event-custom-post' ),
			'edit_item'				=> esc_html__( 'Edit Pricing Table', 'big-event-custom-post' ),
			'new_item'				=> esc_html__( 'New Pricing Table', 'big-event-custom-post' ),
			'view_item'				=> esc_html__( 'View Pricing Table', 'big-event-custom-post' ),
			'search_items'			=> esc_html__( 'Search Pricing Table', 'big-event-custom-post' ),
			'not_found'				=> esc_html__( 'No Pricing Table found', 'big-event-custom-post' ),
			'not_found_in_trash'	=> esc_html__( 'No Pricing Table found in trash', 'big-event-custom-post' ),
			'parent_item_color'		=> '',
			'menu_name'				=> esc_html__( 'Pricing Table', 'big-event-custom-post' )
		);

		// Options
		$args = array(
			'labels'				=> $labels,
			'public'				=> false,
			'public_queryable'		=> true,
			'show_ui'				=> true,
			'show_in_menu'			=> true,
			'query_var'				=> true,
			'rewrite'				=> array( 'slug' => self::$post_type ),
			'capability_type'		=> 'post',
			'has_archive'			=> false,
			'hierarchical'			=> false,
			'menu_position'			=> self::$menu_position,
			'menu_icon'				=> 'dashicons-networking',
			'supports'				=> array( 'title' )
		);

		$labels = apply_filters( 'presscore_post_type_' . self::$post_type . '_labels', $labels );
		$args = apply_filters( 'presscore_post_type_' . self::$post_type . '_args', $args );

		register_post_type( self::$post_type, $args );
		flush_rewrite_rules();

        /* setup taxonomy */

        // titles
        $texanomy_labels = array(
	        'name'             => esc_html__( 'Pricing Categories',        'big-event-custom-post' ),
	        'singular_name'    => esc_html__( 'Pricing Category',          'big-event-custom-post' ),
	        'all_items'        => esc_html__( 'Pricing Categories',        'big-event-custom-post' ),
	        'parent_item'      => esc_html__( 'Parent Pricing Category',   'big-event-custom-post' ),
	        'parent_item_colon'=> esc_html__( 'Parent Pricing Category:',  'big-event-custom-post' ),
	        'edit_item'        => esc_html__( 'Edit Category',             'big-event-custom-post' ), 
	        'update_item'      => esc_html__( 'Update Category',           'big-event-custom-post' ),
	        'add_new_item'     => esc_html__( 'Add New Pricing Category',  'big-event-custom-post' ),
	        'new_item_name'    => esc_html__( 'New Pricing Name',          'big-event-custom-post' ),
	        'menu_name'        => esc_html__( 'Pricing Categories',        'big-event-custom-post' )
        );

        $taxonomy_args = array(
            'hierarchical'          => true,
            'public'                => true,
            'labels'                => $texanomy_labels,
            'show_ui'               => true,
            'rewrite'               => array('slug' => 'pricing_category'),
            'show_admin_column'	=> true,
        );

        $taxonomy_args = apply_filters( 'presscore_taxonomy_' . self::$taxonomy . '_args', $taxonomy_args );

        register_taxonomy( self::$taxonomy, array( self::$post_type ), $taxonomy_args );

	}
}
endif;


/**
 * Register Post Type
 */

if( ! function_exists( 'big_event_register_post_type' ) ) :
	function big_event_register_post_type() {
		Big_Event_Event_Post_Type::register();
		Big_Event_Speakers_Post_Type::register();
		Big_Event_Pricing_Table_Post_Type::register();
	}
endif;
add_action( 'init', 'big_event_register_post_type', 10 );