function treeTooltipOn() { document.getElementById("tree-tooltip").innerHTML = treeTooltips[treeElements.indexOf(this.id)]; }
function treeTooltipOff() { document.getElementById("tree-tooltip").innerHTML = ""; }

var treeElements = ["tree-moveUp", "tree-moveDown", "tree-insert-doc", "tree-info", "tree-remove"];
var treeTooltips = ["Move Up", "Move Down", "Insert Folder", "Insert Doc", "Info", "Delete"];

/*for (var i = 0; i < treeElements.length; i++) {
    document.getElementById(treeElements[i]).onmouseover = treeTooltipOn;
    document.getElementById(treeElements[i]).onmouseout = treeTooltipOff;
}*/

function treeMoveUp() {
    if (tree.mayMoveUp()) {
        tree.moveUp();
    }
}
function treeMoveDown() {
    if (tree.mayMoveDown()) {
        tree.moveDown();
    }
}
function treeMoveLeft() {
    if (tree.mayMoveLeft()) {
        tree.moveLeft();
    }
}
function treeMoveRight() {
    if (tree.mayMoveRight()) {
        tree.moveRight();
    }
}

function treeInsertDoc( )
{
  treeInsert( true );
}

function treeInsert( is_doc )
{
    if( tree.active)
    {
      var node = tree.getActiveNode();
      if( node )
      {
        if( node.isFolder )
          node = node;
        else
          node = node.parentNode;

        tree_insert( is_doc, node.sqlId, node.text );
      }
      else
        tree_insert( is_doc, 0, null );
    }
    else
      tree_insert( is_doc, 0, null );
}


function treeHideInsert() {
    var name = document.getElementById("tree-insert-name");
    var href = document.getElementById("tree-insert-href");
    var title = document.getElementById("tree-insert-title");
    var target = document.getElementById("tree-insert-target");
    name.value = "";
    href.value = "";
    title.value = "";
    target.value = "";
    document.getElementById("tree-insert-form").style.display = "none";
}
function treeInfo() {
    if (tree.active) {
        var node = tree.getActiveNode();
        tree_edit( node.isDoc, node.sqlId );
    }
}
function treeInfoUpdate() {
    var name = document.getElementById("tree-info-name");
    var href = document.getElementById("tree-info-href");
    var title = document.getElementById("tree-info-title");
    var target = document.getElementById("tree-info-target");
    name.value = name.value.trim();
    href.value = href.value.trim();
    if (!name.value) {
        return false;
    }
    if (tree.active) {
        var node = tree.getActiveNode();
        node.text = name.value;
        node.href = href.value;
        node.title = title.value;
        node.target = target.value;
        tree.updateHtml();
        tree_update( node.text, node.sqlId );
    }
}

function treeRemove() {
    if (tree.mayRemove()) {
        if (confirm("Are you sure you want to delete this item?")) {
            tree.remove();
            if (document.getElementById("tree-insert-form").style.display == "block") {
                treeInsert();
            }
            if (document.getElementById("tree-info-form").style.display == "block") {
                treeInfo();
            }
        }
    }
}

document.getElementById("tree-moveUp").onclick    = treeMoveUp;
document.getElementById("tree-moveDown").onclick  = treeMoveDown;

document.getElementById("tree-insert-doc").onclick = treeInsertDoc;
document.getElementById("tree-info").onclick = treeInfo;
document.getElementById("tree-remove").onclick = treeRemove;

/* Finds the index of the first occurence of item in the array, or -1 if not found */
if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function(item) {
        for (var i = 0; i < this.length; ++i) {
            if (this[i] === item) { return i; }
        }
        return -1;
    };
}