<?php    
 /* CAT:Stacked chart */ 

 /* pChart library inclusions */ 
 include("class/pData.class.php"); 
 include("class/pDraw.class.php"); 
 include("class/pImage.class.php"); 

 /* Create and populate the pData object */ 
 $MyData = new pData();   

 $MyData->addPoints(array(4,3,2,3,4,3,2),"Pathetic");
 $MyData->addPoints(array(3,4,1,4,3,4,1),"Satis");
 $MyData->addPoints(array(2,1,4,1,2,1,4),"Good");
 $MyData->addPoints(array(1,2,3,2,1,2,3),"Excellent");


 $MyData->setAxisName(0,"Average Usage"); 
 $MyData->addPoints(array("design","plot","direct","song","dialog","male","female"),"Labels"); 
 $MyData->setSerieDescription("Labels","Months"); 
 $MyData->setAbscissa("Labels"); 
  $MyData->setAxisDisplay(0,AXIS_FORMAT_METRIC,1); 

 /* Normalize all the data series to 100% */ 
 $MyData->normalize(100,"%"); 

 /* Create the pChart object */ 
 $myPicture = new pImage(700,230,$MyData); 
 $myPicture->drawGradientArea(0,0,700,230,DIRECTION_VERTICAL,array("StartR"=>240,"StartG"=>240,"StartB"=>240,"EndR"=>180,"EndG"=>180,"EndB"=>180,"Alpha"=>100)); 
 $myPicture->drawGradientArea(0,0,700,230,DIRECTION_HORIZONTAL,array("StartR"=>240,"StartG"=>240,"StartB"=>240,"EndR"=>180,"EndG"=>180,"EndB"=>180,"Alpha"=>20)); 

 /* Set the default font properties */ 
 $myPicture->setFontProperties(array("FontName"=>"fonts/pf_arma_five.ttf","FontSize"=>6)); 

 /* Draw the scale and the chart */ 
 $myPicture->setGraphArea(60,20,680,190); 
 $myPicture->drawScale(array("DrawSubTicks"=>TRUE,"Mode"=>SCALE_MODE_ADDALL)); 
 $myPicture->setShadow(TRUE,array("X"=>1,"Y"=>1,"R"=>0,"G"=>0,"B"=>0,"Alpha"=>10)); 
 $myPicture->drawStackedBarChart(array("DisplayValues"=>TRUE,"DisplayColor"=>DISPLAY_AUTO,"Gradient"=>TRUE,"GradientMode"=>GRADIENT_EFFECT_CAN,"Surrounding"=>30)); 
 $myPicture->setShadow(FALSE); 

 /* Write the chart legend */ 
 $myPicture->drawLegend(480,210,array("Style"=>LEGEND_NOBORDER,"Mode"=>LEGEND_HORIZONTAL)); 

 /* Render the picture (choose the best way) */ 
 $myPicture->autoOutput("test/example.drawStackedBarChart.can.png"); 
?>4